@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Flag specifying if the resource monitoring is enabled or disabled.
 */
public enum class MonitoringStatus(
    public val javaValue: com.pulumi.azurenative.datadog.enums.MonitoringStatus,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.enums.MonitoringStatus> {
    Enabled(com.pulumi.azurenative.datadog.enums.MonitoringStatus.Enabled),
    Disabled(com.pulumi.azurenative.datadog.enums.MonitoringStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datadog.enums.MonitoringStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.enums.MonitoringStatus): MonitoringStatus = MonitoringStatus.values().first { it.javaValue == javaType }
    }
}
