@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.GetMonitoredSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationName The configuration name. Only 'default' value is supported.
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMonitoredSubscriptionPlainArgs(
    public val configurationName: String,
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.GetMonitoredSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.GetMonitoredSubscriptionPlainArgs =
        com.pulumi.azurenative.datadog.inputs.GetMonitoredSubscriptionPlainArgs.builder()
            .configurationName(configurationName.let({ args0 -> args0 }))
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMonitoredSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetMonitoredSubscriptionPlainArgsBuilder internal constructor() {
    private var configurationName: String? = null

    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The configuration name. Only 'default' value is supported.
     */
    @JvmName("jonfwivjbqovxyft")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("imrmheikajlyqdlj")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xvkphfcocxqwnqhm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMonitoredSubscriptionPlainArgs = GetMonitoredSubscriptionPlainArgs(
        configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
