@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.MetricRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set of rules for sending metrics for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 */
public data class MetricRulesArgs(
    public val filteringTags: Output<List<FilteringTagArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.MetricRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.MetricRulesArgs =
        com.pulumi.azurenative.datadog.inputs.MetricRulesArgs.builder()
            .filteringTags(
                filteringTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MetricRulesArgs].
 */
@PulumiTagMarker
public class MetricRulesArgsBuilder internal constructor() {
    private var filteringTags: Output<List<FilteringTagArgs>>? = null

    /**
     * @param value List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("fcjuytgmadioulyo")
    public suspend fun filteringTags(`value`: Output<List<FilteringTagArgs>>) {
        this.filteringTags = value
    }

    @JvmName("imogatvitmaimrew")
    public suspend fun filteringTags(vararg values: Output<FilteringTagArgs>) {
        this.filteringTags = Output.all(values.asList())
    }

    /**
     * @param values List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("evasyxlbqakvmiqy")
    public suspend fun filteringTags(values: List<Output<FilteringTagArgs>>) {
        this.filteringTags = Output.all(values)
    }

    /**
     * @param value List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("lxkltjoanfamveup")
    public suspend fun filteringTags(`value`: List<FilteringTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("xsjokiycctvrvxuf")
    public suspend fun filteringTags(argument: List<suspend FilteringTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("angowwvbukapmtee")
    public suspend fun filteringTags(vararg argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("dmsaiwsynfdqqsqh")
    public suspend fun filteringTags(argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilteringTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param values List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("cfrvdbxctuybwrtd")
    public suspend fun filteringTags(vararg values: FilteringTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    internal fun build(): MetricRulesArgs = MetricRulesArgs(
        filteringTags = filteringTags,
    )
}
