@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property agentVersion The agent version.
 * @property installMethod
 * @property logsAgent
 */
public data class DatadogHostMetadataResponse(
    public val agentVersion: String? = null,
    public val installMethod: DatadogInstallMethodResponse? = null,
    public val logsAgent: DatadogLogsAgentResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.DatadogHostMetadataResponse): DatadogHostMetadataResponse = DatadogHostMetadataResponse(
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            installMethod = javaType.installMethod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.DatadogInstallMethodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logsAgent = javaType.logsAgent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.DatadogLogsAgentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
