@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aliases The aliases for the host.
 * @property apps The Datadog integrations reporting metrics for the host.
 * @property meta
 * @property name The name of the host.
 */
public data class DatadogHostResponse(
    public val aliases: List<String>? = null,
    public val apps: List<String>? = null,
    public val meta: DatadogHostMetadataResponse? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.DatadogHostResponse): DatadogHostResponse = DatadogHostResponse(
            aliases = javaType.aliases().map({ args0 -> args0 }),
            apps = javaType.apps().map({ args0 -> args0 }),
            meta = javaType.meta().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.DatadogHostMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
