@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Datadog organization properties
 * @property id Id of the Datadog organization.
 * @property name Name of the Datadog organization.
 */
public data class DatadogOrganizationPropertiesResponse(
    public val id: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.DatadogOrganizationPropertiesResponse): DatadogOrganizationPropertiesResponse = DatadogOrganizationPropertiesResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
