@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property created The time of creation of the API key.
 * @property createdBy The user that created the API key.
 * @property key The value of the API key.
 * @property name The name of the API key.
 */
public data class GetMonitorDefaultKeyResult(
    public val created: String? = null,
    public val createdBy: String? = null,
    public val key: String,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.GetMonitorDefaultKeyResult): GetMonitorDefaultKeyResult = GetMonitorDefaultKeyResult(
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
