@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Set of rules for sending metrics for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 */
public data class MetricRulesResponse(
    public val filteringTags: List<FilteringTagResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.MetricRulesResponse): MetricRulesResponse = MetricRulesResponse(
            filteringTags = javaType.filteringTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.FilteringTagResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
