@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties specific to the monitor resource.
 * @property datadogOrganizationProperties Datadog organization properties
 * @property liftrResourceCategory
 * @property liftrResourcePreference The priority of the resource.
 * @property marketplaceSubscriptionStatus Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
 * @property monitoringStatus Flag specifying if the resource monitoring is enabled or disabled.
 * @property provisioningState
 * @property userInfo User info
 */
public data class MonitorPropertiesResponse(
    public val datadogOrganizationProperties: DatadogOrganizationPropertiesResponse? = null,
    public val liftrResourceCategory: String,
    public val liftrResourcePreference: Int,
    public val marketplaceSubscriptionStatus: String,
    public val monitoringStatus: String? = null,
    public val provisioningState: String,
    public val userInfo: UserInfoResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.MonitorPropertiesResponse): MonitorPropertiesResponse = MonitorPropertiesResponse(
            datadogOrganizationProperties = javaType.datadogOrganizationProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.DatadogOrganizationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            liftrResourceCategory = javaType.liftrResourceCategory(),
            liftrResourcePreference = javaType.liftrResourcePreference(),
            marketplaceSubscriptionStatus = javaType.marketplaceSubscriptionStatus(),
            monitoringStatus = javaType.monitoringStatus().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            userInfo = javaType.userInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
