@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the properties for a TagRules resource.
 * @property automuting Configuration to enable/disable auto-muting flag
 * @property logRules Set of rules for sending logs for the Monitor resource.
 * @property metricRules Set of rules for sending metrics for the Monitor resource.
 * @property provisioningState
 */
public data class MonitoringTagRulesPropertiesResponse(
    public val automuting: Boolean? = null,
    public val logRules: LogRulesResponse? = null,
    public val metricRules: MetricRulesResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.MonitoringTagRulesPropertiesResponse): MonitoringTagRulesPropertiesResponse = MonitoringTagRulesPropertiesResponse(
            automuting = javaType.automuting().map({ args0 -> args0 }).orElse(null),
            logRules = javaType.logRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.LogRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metricRules = javaType.metricRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.MetricRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
