@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User info
 * @property emailAddress Email of the user used by Datadog for contacting them if needed
 * @property name Name of the user
 * @property phoneNumber Phone number of the user used by Datadog for contacting them if needed
 */
public data class UserInfoResponse(
    public val emailAddress: String? = null,
    public val name: String? = null,
    public val phoneNumber: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.UserInfoResponse): UserInfoResponse = UserInfoResponse(
            emailAddress = javaType.emailAddress().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            phoneNumber = javaType.phoneNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
