@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataFlow].
 */
@PulumiTagMarker
public class DataFlowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataFlowArgs = DataFlowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataFlowArgsBuilder.() -> Unit) {
        val builder = DataFlowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataFlow {
        val builtJavaResource = com.pulumi.azurenative.datafactory.DataFlow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataFlow(builtJavaResource)
    }
}

/**
 * Data flow resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### DataFlows_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataFlow = new AzureNative.DataFactory.DataFlow("dataFlow", new()
 *     {
 *         DataFlowName = "exampleDataFlow",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.MappingDataFlowArgs
 *         {
 *             Description = "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 *             ScriptLines = new[]
 *             {
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: false,",
 *                 "validateSchema: false) ~> USDCurrency",
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: true,",
 *                 "validateSchema: false) ~> CADSource",
 *                 "USDCurrency, CADSource union(byName: true)~> Union",
 *                 "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                 "NewCurrencyColumn split(Country == 'USD',",
 *                 "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                 "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                 "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 *             },
 *             Sinks = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "USDOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDSink",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CADOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSink",
 *                 },
 *             },
 *             Sources = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetUSD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDCurrency",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetCAD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSource",
 *                 },
 *             },
 *             Type = "MappingDataFlow",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewDataFlow(ctx, "dataFlow", &datafactory.DataFlowArgs{
 * 			DataFlowName: pulumi.String("exampleDataFlow"),
 * 			FactoryName:  pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.MappingDataFlow{
 * 				Description: "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 * 				ScriptLines: []string{
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: false,",
 * 					"validateSchema: false) ~> USDCurrency",
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: true,",
 * 					"validateSchema: false) ~> CADSource",
 * 					"USDCurrency, CADSource union(byName: true)~> Union",
 * 					"Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 * 					"NewCurrencyColumn split(Country == 'USD',",
 * 					"Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 * 					"ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 * 					"ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 * 				},
 * 				Sinks: []datafactory.DataFlowSink{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "USDOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDSink",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CADOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSink",
 * 					},
 * 				},
 * 				Sources: []datafactory.DataFlowSource{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetUSD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDCurrency",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetCAD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSource",
 * 					},
 * 				},
 * 				Type: "MappingDataFlow",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.DataFlow;
 * import com.pulumi.azurenative.datafactory.DataFlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataFlow = new DataFlow("dataFlow", DataFlowArgs.builder()
 *             .dataFlowName("exampleDataFlow")
 *             .factoryName("exampleFactoryName")
 *             .properties(MappingDataFlowArgs.builder()
 *                 .description("Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.")
 *                 .scriptLines(
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: false,",
 *                     "validateSchema: false) ~> USDCurrency",
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: true,",
 *                     "validateSchema: false) ~> CADSource",
 *                     "USDCurrency, CADSource union(byName: true)~> Union",
 *                     "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                     "NewCurrencyColumn split(Country == 'USD',",
 *                     "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                     "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                     "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink")
 *                 .sinks(
 *                     DataFlowSinkArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("USDOutput")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("USDSink")
 *                         .build(),
 *                     DataFlowSinkArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("CADOutput")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("CADSink")
 *                         .build())
 *                 .sources(
 *                     DataFlowSourceArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("CurrencyDatasetUSD")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("USDCurrency")
 *                         .build(),
 *                     DataFlowSourceArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("CurrencyDatasetCAD")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("CADSource")
 *                         .build())
 *                 .type("MappingDataFlow")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### DataFlows_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataFlow = new AzureNative.DataFactory.DataFlow("dataFlow", new()
 *     {
 *         DataFlowName = "exampleDataFlow",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.MappingDataFlowArgs
 *         {
 *             Description = "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 *             ScriptLines = new[]
 *             {
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: false,",
 *                 "validateSchema: false) ~> USDCurrency",
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: true,",
 *                 "validateSchema: false) ~> CADSource",
 *                 "USDCurrency, CADSource union(byName: true)~> Union",
 *                 "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                 "NewCurrencyColumn split(Country == 'USD',",
 *                 "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                 "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                 "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 *             },
 *             Sinks = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "USDOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDSink",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CADOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSink",
 *                 },
 *             },
 *             Sources = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetUSD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDCurrency",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetCAD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSource",
 *                 },
 *             },
 *             Type = "MappingDataFlow",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewDataFlow(ctx, "dataFlow", &datafactory.DataFlowArgs{
 * 			DataFlowName: pulumi.String("exampleDataFlow"),
 * 			FactoryName:  pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.MappingDataFlow{
 * 				Description: "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 * 				ScriptLines: []string{
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: false,",
 * 					"validateSchema: false) ~> USDCurrency",
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: true,",
 * 					"validateSchema: false) ~> CADSource",
 * 					"USDCurrency, CADSource union(byName: true)~> Union",
 * 					"Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 * 					"NewCurrencyColumn split(Country == 'USD',",
 * 					"Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 * 					"ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 * 					"ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 * 				},
 * 				Sinks: []datafactory.DataFlowSink{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "USDOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDSink",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CADOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSink",
 * 					},
 * 				},
 * 				Sources: []datafactory.DataFlowSource{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetUSD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDCurrency",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetCAD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSource",
 * 					},
 * 				},
 * 				Type: "MappingDataFlow",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.DataFlow;
 * import com.pulumi.azurenative.datafactory.DataFlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataFlow = new DataFlow("dataFlow", DataFlowArgs.builder()
 *             .dataFlowName("exampleDataFlow")
 *             .factoryName("exampleFactoryName")
 *             .properties(MappingDataFlowArgs.builder()
 *                 .description("Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.")
 *                 .scriptLines(
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: false,",
 *                     "validateSchema: false) ~> USDCurrency",
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: true,",
 *                     "validateSchema: false) ~> CADSource",
 *                     "USDCurrency, CADSource union(byName: true)~> Union",
 *                     "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                     "NewCurrencyColumn split(Country == 'USD',",
 *                     "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                     "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                     "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink")
 *                 .sinks(
 *                     DataFlowSinkArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("USDOutput")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("USDSink")
 *                         .build(),
 *                     DataFlowSinkArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("CADOutput")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("CADSink")
 *                         .build())
 *                 .sources(
 *                     DataFlowSourceArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("CurrencyDatasetUSD")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("USDCurrency")
 *                         .build(),
 *                     DataFlowSourceArgs.builder()
 *                         .dataset(DatasetReferenceArgs.builder()
 *                             .referenceName("CurrencyDatasetCAD")
 *                             .type("DatasetReference")
 *                             .build())
 *                         .name("CADSource")
 *                         .build())
 *                 .type("MappingDataFlow")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:DataFlow exampleDataFlow /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/dataflows/{dataFlowName}
 * ```
 */
public class DataFlow internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.DataFlow,
) : KotlinCustomResource(javaResource, DataFlowMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Data flow properties.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataFlowMapper : ResourceMapper<DataFlow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.DataFlow::class == javaResource::class

    override fun map(javaResource: Resource): DataFlow = DataFlow(
        javaResource as
            com.pulumi.azurenative.datafactory.DataFlow,
    )
}

/**
 * @see [DataFlow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataFlow].
 */
public suspend fun dataFlow(name: String, block: suspend DataFlowResourceBuilder.() -> Unit): DataFlow {
    val builder = DataFlowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataFlow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataFlow(name: String): DataFlow {
    val builder = DataFlowResourceBuilder()
    builder.name(name)
    return builder.build()
}
