@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.kotlin.outputs.EncryptionConfigurationResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryGitHubConfigurationResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryIdentityResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryVSTSConfigurationResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.GlobalParameterSpecificationResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.PurviewConfigurationResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.datafactory.kotlin.outputs.EncryptionConfigurationResponse.Companion.toKotlin as encryptionConfigurationResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryIdentityResponse.Companion.toKotlin as factoryIdentityResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GlobalParameterSpecificationResponse.Companion.toKotlin as globalParameterSpecificationResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.PurviewConfigurationResponse.Companion.toKotlin as purviewConfigurationResponseToKotlin

/**
 * Builder for [Factory].
 */
@PulumiTagMarker
public class FactoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FactoryArgs = FactoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FactoryArgsBuilder.() -> Unit) {
        val builder = FactoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Factory {
        val builtJavaResource = com.pulumi.azurenative.datafactory.Factory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Factory(builtJavaResource)
    }
}

/**
 * Factory resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2017-09-01-preview.
 * ## Example Usage
 * ### Factories_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var factory = new AzureNative.DataFactory.Factory("factory", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         Location = "East US",
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewFactory(ctx, "factory", &datafactory.FactoryArgs{
 * 			FactoryName:       pulumi.String("exampleFactoryName"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Factory;
 * import com.pulumi.azurenative.datafactory.FactoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var factory = new Factory("factory", FactoryArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .location("East US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:Factory exampleFactoryName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}
 * ```
 */
public class Factory internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.Factory,
) : KotlinCustomResource(javaResource, FactoryMapper) {
    /**
     * Time the factory was created in ISO8601 format.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Etag identifies change in the resource.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * Properties to enable Customer Managed Key for the factory.
     */
    public val encryption: Output<EncryptionConfigurationResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of parameters for factory.
     */
    public val globalParameters: Output<Map<String, GlobalParameterSpecificationResponse>>?
        get() = javaResource.globalParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            globalParameterSpecificationResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Managed service identity of the factory.
     */
    public val identity: Output<FactoryIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    factoryIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Factory provisioning state, example Succeeded.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether or not public network access is allowed for the data factory.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Purview information of the factory.
     */
    public val purviewConfiguration: Output<PurviewConfigurationResponse>?
        get() = javaResource.purviewConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> purviewConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Git repo information of the factory.
     */
    public val repoConfiguration:
        Output<Either<FactoryGitHubConfigurationResponse, FactoryVSTSConfigurationResponse>>?
        get() = javaResource.repoConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryGitHubConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryVSTSConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the factory.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object FactoryMapper : ResourceMapper<Factory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.Factory::class == javaResource::class

    override fun map(javaResource: Resource): Factory = Factory(
        javaResource as
            com.pulumi.azurenative.datafactory.Factory,
    )
}

/**
 * @see [Factory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Factory].
 */
public suspend fun factory(name: String, block: suspend FactoryResourceBuilder.() -> Unit): Factory {
    val builder = FactoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Factory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun factory(name: String): Factory {
    val builder = FactoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
