@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedPrivateEndpointResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedPrivateEndpointResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedPrivateEndpoint].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPrivateEndpointArgsBuilder.() -> Unit) {
        val builder = ManagedPrivateEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedPrivateEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.datafactory.ManagedPrivateEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedPrivateEndpoint(builtJavaResource)
    }
}

/**
 * Managed private endpoint resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### ManagedVirtualNetworks_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedPrivateEndpoint = new AzureNative.DataFactory.ManagedPrivateEndpoint("managedPrivateEndpoint", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         ManagedPrivateEndpointName = "exampleManagedPrivateEndpointName",
 *         ManagedVirtualNetworkName = "exampleManagedVirtualNetworkName",
 *         Properties = new AzureNative.DataFactory.Inputs.ManagedPrivateEndpointArgs
 *         {
 *             Fqdns = new() { },
 *             GroupId = "blob",
 *             PrivateLinkResourceId = "/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleBlobStorage",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewManagedPrivateEndpoint(ctx, "managedPrivateEndpoint", &datafactory.ManagedPrivateEndpointArgs{
 * 			FactoryName:                pulumi.String("exampleFactoryName"),
 * 			ManagedPrivateEndpointName: pulumi.String("exampleManagedPrivateEndpointName"),
 * 			ManagedVirtualNetworkName:  pulumi.String("exampleManagedVirtualNetworkName"),
 * 			Properties: &datafactory.ManagedPrivateEndpointTypeArgs{
 * 				Fqdns:                 pulumi.StringArray{},
 * 				GroupId:               pulumi.String("blob"),
 * 				PrivateLinkResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleBlobStorage"),
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.ManagedPrivateEndpoint;
 * import com.pulumi.azurenative.datafactory.ManagedPrivateEndpointArgs;
 * import com.pulumi.azurenative.datafactory.inputs.ManagedPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedPrivateEndpoint = new ManagedPrivateEndpoint("managedPrivateEndpoint", ManagedPrivateEndpointArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .managedPrivateEndpointName("exampleManagedPrivateEndpointName")
 *             .managedVirtualNetworkName("exampleManagedVirtualNetworkName")
 *             .properties(ManagedPrivateEndpointArgs.builder()
 *                 .fqdns()
 *                 .groupId("blob")
 *                 .privateLinkResourceId("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleBlobStorage")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:ManagedPrivateEndpoint exampleManagedPrivateEndpointName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}
 * ```
 */
public class ManagedPrivateEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.ManagedPrivateEndpoint,
) : KotlinCustomResource(javaResource, ManagedPrivateEndpointMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Managed private endpoint properties.
     */
    public val properties: Output<ManagedPrivateEndpointResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedPrivateEndpointMapper : ResourceMapper<ManagedPrivateEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.ManagedPrivateEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPrivateEndpoint =
        ManagedPrivateEndpoint(
            javaResource as
                com.pulumi.azurenative.datafactory.ManagedPrivateEndpoint,
        )
}

/**
 * @see [ManagedPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPrivateEndpoint].
 */
public suspend fun managedPrivateEndpoint(
    name: String,
    block: suspend ManagedPrivateEndpointResourceBuilder.() -> Unit,
): ManagedPrivateEndpoint {
    val builder = ManagedPrivateEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPrivateEndpoint(name: String): ManagedPrivateEndpoint {
    val builder = ManagedPrivateEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
