@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Trigger].
 */
@PulumiTagMarker
public class TriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TriggerArgs = TriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TriggerArgsBuilder.() -> Unit) {
        val builder = TriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Trigger {
        val builtJavaResource = com.pulumi.azurenative.datafactory.Trigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trigger(builtJavaResource)
    }
}

/**
 * Trigger resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Triggers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trigger = new AzureNative.DataFactory.Trigger("trigger", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.ScheduleTriggerArgs
 *         {
 *             Pipelines = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.TriggerPipelineReferenceArgs
 *                 {
 *                     Parameters =
 *                     {
 *                         { "OutputBlobNameList", new[]
 *                         {
 *                             "exampleoutput.csv",
 *                         } },
 *                     },
 *                     PipelineReference = new AzureNative.DataFactory.Inputs.PipelineReferenceArgs
 *                     {
 *                         ReferenceName = "examplePipeline",
 *                         Type = "PipelineReference",
 *                     },
 *                 },
 *             },
 *             Recurrence = new AzureNative.DataFactory.Inputs.ScheduleTriggerRecurrenceArgs
 *             {
 *                 EndTime = "2018-06-16T00:55:13.8441801Z",
 *                 Frequency = AzureNative.DataFactory.RecurrenceFrequency.Minute,
 *                 Interval = 4,
 *                 StartTime = "2018-06-16T00:39:13.8441801Z",
 *                 TimeZone = "UTC",
 *             },
 *             Type = "ScheduleTrigger",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         TriggerName = "exampleTrigger",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewTrigger(ctx, "trigger", &datafactory.TriggerArgs{
 * 			FactoryName: pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.ScheduleTrigger{
 * 				Pipelines: []datafactory.TriggerPipelineReference{
 * 					{
 * 						Parameters: {
 * 							"OutputBlobNameList": []string{
 * 								"exampleoutput.csv",
 * 							},
 * 						},
 * 						PipelineReference: {
 * 							ReferenceName: "examplePipeline",
 * 							Type:          "PipelineReference",
 * 						},
 * 					},
 * 				},
 * 				Recurrence: datafactory.ScheduleTriggerRecurrence{
 * 					EndTime:   "2018-06-16T00:55:13.8441801Z",
 * 					Frequency: datafactory.RecurrenceFrequencyMinute,
 * 					Interval:  4,
 * 					StartTime: "2018-06-16T00:39:13.8441801Z",
 * 					TimeZone:  "UTC",
 * 				},
 * 				Type: "ScheduleTrigger",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			TriggerName:       pulumi.String("exampleTrigger"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Trigger;
 * import com.pulumi.azurenative.datafactory.TriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trigger = new Trigger("trigger", TriggerArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .properties(ScheduleTriggerArgs.builder()
 *                 .pipelines(TriggerPipelineReferenceArgs.builder()
 *                     .parameters(Map.of("OutputBlobNameList", "exampleoutput.csv"))
 *                     .pipelineReference(PipelineReferenceArgs.builder()
 *                         .referenceName("examplePipeline")
 *                         .type("PipelineReference")
 *                         .build())
 *                     .build())
 *                 .recurrence(ScheduleTriggerRecurrenceArgs.builder()
 *                     .endTime("2018-06-16T00:55:13.8441801Z")
 *                     .frequency("Minute")
 *                     .interval(4)
 *                     .startTime("2018-06-16T00:39:13.8441801Z")
 *                     .timeZone("UTC")
 *                     .build())
 *                 .type("ScheduleTrigger")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .triggerName("exampleTrigger")
 *             .build());
 *     }
 * }
 * ```
 * ### Triggers_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trigger = new AzureNative.DataFactory.Trigger("trigger", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.ScheduleTriggerArgs
 *         {
 *             Description = "Example description",
 *             Pipelines = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.TriggerPipelineReferenceArgs
 *                 {
 *                     Parameters =
 *                     {
 *                         { "OutputBlobNameList", new[]
 *                         {
 *                             "exampleoutput.csv",
 *                         } },
 *                     },
 *                     PipelineReference = new AzureNative.DataFactory.Inputs.PipelineReferenceArgs
 *                     {
 *                         ReferenceName = "examplePipeline",
 *                         Type = "PipelineReference",
 *                     },
 *                 },
 *             },
 *             Recurrence = new AzureNative.DataFactory.Inputs.ScheduleTriggerRecurrenceArgs
 *             {
 *                 EndTime = "2018-06-16T00:55:14.905167Z",
 *                 Frequency = AzureNative.DataFactory.RecurrenceFrequency.Minute,
 *                 Interval = 4,
 *                 StartTime = "2018-06-16T00:39:14.905167Z",
 *                 TimeZone = "UTC",
 *             },
 *             Type = "ScheduleTrigger",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         TriggerName = "exampleTrigger",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewTrigger(ctx, "trigger", &datafactory.TriggerArgs{
 * 			FactoryName: pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.ScheduleTrigger{
 * 				Description: "Example description",
 * 				Pipelines: []datafactory.TriggerPipelineReference{
 * 					{
 * 						Parameters: {
 * 							"OutputBlobNameList": []string{
 * 								"exampleoutput.csv",
 * 							},
 * 						},
 * 						PipelineReference: {
 * 							ReferenceName: "examplePipeline",
 * 							Type:          "PipelineReference",
 * 						},
 * 					},
 * 				},
 * 				Recurrence: datafactory.ScheduleTriggerRecurrence{
 * 					EndTime:   "2018-06-16T00:55:14.905167Z",
 * 					Frequency: datafactory.RecurrenceFrequencyMinute,
 * 					Interval:  4,
 * 					StartTime: "2018-06-16T00:39:14.905167Z",
 * 					TimeZone:  "UTC",
 * 				},
 * 				Type: "ScheduleTrigger",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			TriggerName:       pulumi.String("exampleTrigger"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Trigger;
 * import com.pulumi.azurenative.datafactory.TriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trigger = new Trigger("trigger", TriggerArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .properties(ScheduleTriggerArgs.builder()
 *                 .description("Example description")
 *                 .pipelines(TriggerPipelineReferenceArgs.builder()
 *                     .parameters(Map.of("OutputBlobNameList", "exampleoutput.csv"))
 *                     .pipelineReference(PipelineReferenceArgs.builder()
 *                         .referenceName("examplePipeline")
 *                         .type("PipelineReference")
 *                         .build())
 *                     .build())
 *                 .recurrence(ScheduleTriggerRecurrenceArgs.builder()
 *                     .endTime("2018-06-16T00:55:14.905167Z")
 *                     .frequency("Minute")
 *                     .interval(4)
 *                     .startTime("2018-06-16T00:39:14.905167Z")
 *                     .timeZone("UTC")
 *                     .build())
 *                 .type("ScheduleTrigger")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .triggerName("exampleTrigger")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:Trigger exampleTrigger /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}
 * ```
 */
public class Trigger internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.Trigger,
) : KotlinCustomResource(javaResource, TriggerMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the trigger.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TriggerMapper : ResourceMapper<Trigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.Trigger::class == javaResource::class

    override fun map(javaResource: Resource): Trigger = Trigger(
        javaResource as
            com.pulumi.azurenative.datafactory.Trigger,
    )
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trigger].
 */
public suspend fun trigger(name: String, block: suspend TriggerResourceBuilder.() -> Unit): Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trigger(name: String): Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
