@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 */
public enum class ActivityOnInactiveMarkAs(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs> {
    Succeeded(com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs.Succeeded),
    Failed(com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs.Failed),
    Skipped(com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs.Skipped),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.ActivityOnInactiveMarkAs): ActivityOnInactiveMarkAs =
            ActivityOnInactiveMarkAs.values().first { it.javaValue == javaType }
    }
}
