@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
 */
public enum class CassandraSourceReadConsistencyLevels(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels> {
    ALL(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.ALL),
    EACH_QUORUM(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.EACH_QUORUM),
    QUORUM(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.QUORUM),
    LOCAL_QUORUM(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.LOCAL_QUORUM),
    ONE(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.ONE),
    TWO(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.TWO),
    THREE(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.THREE),
    LOCAL_ONE(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.LOCAL_ONE),
    SERIAL(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.SERIAL),
    LOCAL_SERIAL(com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels.LOCAL_SERIAL),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.CassandraSourceReadConsistencyLevels): CassandraSourceReadConsistencyLevels =
            CassandraSourceReadConsistencyLevels.values().first { it.javaValue == javaType }
    }
}
