@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication method used to access the Hive server.
 */
public enum class HiveAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType> {
    Anonymous(com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType.Anonymous),
    Username(com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType.Username),
    UsernameAndPassword(com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType.UsernameAndPassword),
    WindowsAzureHDInsightService(com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType.WindowsAzureHDInsightService),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.HiveAuthenticationType): HiveAuthenticationType = HiveAuthenticationType.values().first { it.javaValue == javaType }
    }
}
