@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication type to use.
 */
public enum class ImpalaAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType> {
    Anonymous(com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType.Anonymous),
    SASLUsername(com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType.SASLUsername),
    UsernameAndPassword(com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType.UsernameAndPassword),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.ImpalaAuthenticationType): ImpalaAuthenticationType =
            ImpalaAuthenticationType.values().first { it.javaValue == javaType }
    }
}
