@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
 */
public enum class IntegrationRuntimeSsisCatalogPricingTier(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier> {
    Basic(com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier.Basic),
    Standard(com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier.Standard),
    Premium(com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier.Premium),
    PremiumRS(com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier.PremiumRS),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.IntegrationRuntimeSsisCatalogPricingTier): IntegrationRuntimeSsisCatalogPricingTier =
            IntegrationRuntimeSsisCatalogPricingTier.values().first { it.javaValue == javaType }
    }
}
