@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication mechanism used to connect to the Phoenix server.
 */
public enum class PhoenixAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType> {
    Anonymous(com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType.Anonymous),
    UsernameAndPassword(com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType.UsernameAndPassword),
    WindowsAzureHDInsightService(com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType.WindowsAzureHDInsightService),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.PhoenixAuthenticationType): PhoenixAuthenticationType =
            PhoenixAuthenticationType.values().first { it.javaValue == javaType }
    }
}
