@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication mechanism used to connect to the Presto server.
 */
public enum class PrestoAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.PrestoAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.PrestoAuthenticationType> {
    Anonymous(com.pulumi.azurenative.datafactory.enums.PrestoAuthenticationType.Anonymous),
    LDAP(com.pulumi.azurenative.datafactory.enums.PrestoAuthenticationType.LDAP),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.PrestoAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.PrestoAuthenticationType): PrestoAuthenticationType =
            PrestoAuthenticationType.values().first { it.javaValue == javaType }
    }
}
