@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not public network access is allowed for the data factory.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.datafactory.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.datafactory.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
