@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication type to be used to connect to the SAP HANA server.
 */
public enum class SapHanaAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.SapHanaAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.SapHanaAuthenticationType> {
    Basic(com.pulumi.azurenative.datafactory.enums.SapHanaAuthenticationType.Basic),
    Windows(com.pulumi.azurenative.datafactory.enums.SapHanaAuthenticationType.Windows),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.SapHanaAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.SapHanaAuthenticationType): SapHanaAuthenticationType =
            SapHanaAuthenticationType.values().first { it.javaValue == javaType }
    }
}
