@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication method used to access the Spark server.
 */
public enum class SparkAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType> {
    Anonymous(com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType.Anonymous),
    Username(com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType.Username),
    UsernameAndPassword(com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType.UsernameAndPassword),
    WindowsAzureHDInsightService(com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType.WindowsAzureHDInsightService),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.SparkAuthenticationType): SparkAuthenticationType =
            SparkAuthenticationType.values().first { it.javaValue == javaType }
    }
}
