@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ActivityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Execution policy for an activity.
 * @property retry Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property retryIntervalInSeconds Interval between each retry attempt (in seconds). The default is 30 sec.
 * @property secureInput When set to true, Input from activity is considered as secure and will not be logged to monitoring.
 * @property secureOutput When set to true, Output from activity is considered as secure and will not be logged to monitoring.
 * @property timeout Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class ActivityPolicyArgs(
    public val retry: Output<Any>? = null,
    public val retryIntervalInSeconds: Output<Int>? = null,
    public val secureInput: Output<Boolean>? = null,
    public val secureOutput: Output<Boolean>? = null,
    public val timeout: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ActivityPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ActivityPolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.ActivityPolicyArgs.builder()
            .retry(retry?.applyValue({ args0 -> args0 }))
            .retryIntervalInSeconds(retryIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .secureInput(secureInput?.applyValue({ args0 -> args0 }))
            .secureOutput(secureOutput?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActivityPolicyArgs].
 */
@PulumiTagMarker
public class ActivityPolicyArgsBuilder internal constructor() {
    private var retry: Output<Any>? = null

    private var retryIntervalInSeconds: Output<Int>? = null

    private var secureInput: Output<Boolean>? = null

    private var secureOutput: Output<Boolean>? = null

    private var timeout: Output<Any>? = null

    /**
     * @param value Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("cdqteyduqsqpwyhw")
    public suspend fun retry(`value`: Output<Any>) {
        this.retry = value
    }

    /**
     * @param value Interval between each retry attempt (in seconds). The default is 30 sec.
     */
    @JvmName("ctrlwoktlqfgdrej")
    public suspend fun retryIntervalInSeconds(`value`: Output<Int>) {
        this.retryIntervalInSeconds = value
    }

    /**
     * @param value When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("qtjxdmdldykqrooq")
    public suspend fun secureInput(`value`: Output<Boolean>) {
        this.secureInput = value
    }

    /**
     * @param value When set to true, Output from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("uacvotwuomwicmlv")
    public suspend fun secureOutput(`value`: Output<Boolean>) {
        this.secureOutput = value
    }

    /**
     * @param value Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("pdivxvjhkhgyeqvx")
    public suspend fun timeout(`value`: Output<Any>) {
        this.timeout = value
    }

    /**
     * @param value Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("atoycxpeeoqkokhh")
    public suspend fun retry(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retry = mapped
    }

    /**
     * @param value Interval between each retry attempt (in seconds). The default is 30 sec.
     */
    @JvmName("ngfjkivxwecolort")
    public suspend fun retryIntervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryIntervalInSeconds = mapped
    }

    /**
     * @param value When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("bsrwkejaimsnrbgs")
    public suspend fun secureInput(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureInput = mapped
    }

    /**
     * @param value When set to true, Output from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("cngqyniexluyoawn")
    public suspend fun secureOutput(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureOutput = mapped
    }

    /**
     * @param value Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ehubhjscopgrfcpb")
    public suspend fun timeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ActivityPolicyArgs = ActivityPolicyArgs(
        retry = retry,
        retryIntervalInSeconds = retryIntervalInSeconds,
        secureInput = secureInput,
        secureOutput = secureOutput,
        timeout = timeout,
    )
}
