@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.AmazonRdsForSqlAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Amazon RDS for SQL Server linked service.
 * @property alwaysEncryptedSettings Sql always encrypted properties.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property applicationIntent The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
 * @property authenticationType The type used for authentication. Type: string.
 * @property commandTimeout The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property connectRetryCount The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
 * @property connectRetryInterval The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
 * @property connectTimeout The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property database The name of the database, used by recommended version. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encrypt Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property failoverPartner The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
 * @property hostNameInCertificate The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
 * @property integratedSecurity Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property loadBalanceTimeout The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property maxPoolSize The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property minPoolSize The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property multiSubnetFailover If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property multipleActiveResultSets When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property packetSize The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property parameters Parameters for linked service.
 * @property password The on-premises Windows authentication password.
 * @property pooling Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property server The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
 * @property trustServerCertificate Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property type Type of linked service.
 * Expected value is 'AmazonRdsForSqlServer'.
 * @property userName The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
 */
public data class AmazonRdsForSqlServerLinkedServiceArgs(
    public val alwaysEncryptedSettings: Output<SqlAlwaysEncryptedPropertiesArgs>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val applicationIntent: Output<Any>? = null,
    public val authenticationType: Output<Either<String, AmazonRdsForSqlAuthenticationType>>? = null,
    public val commandTimeout: Output<Any>? = null,
    public val connectRetryCount: Output<Any>? = null,
    public val connectRetryInterval: Output<Any>? = null,
    public val connectTimeout: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val database: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encrypt: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val failoverPartner: Output<Any>? = null,
    public val hostNameInCertificate: Output<Any>? = null,
    public val integratedSecurity: Output<Any>? = null,
    public val loadBalanceTimeout: Output<Any>? = null,
    public val maxPoolSize: Output<Any>? = null,
    public val minPoolSize: Output<Any>? = null,
    public val multiSubnetFailover: Output<Any>? = null,
    public val multipleActiveResultSets: Output<Any>? = null,
    public val packetSize: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val pooling: Output<Any>? = null,
    public val server: Output<Any>? = null,
    public val trustServerCertificate: Output<Any>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForSqlServerLinkedServiceArgs.builder()
            .alwaysEncryptedSettings(
                alwaysEncryptedSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .applicationIntent(applicationIntent?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .commandTimeout(commandTimeout?.applyValue({ args0 -> args0 }))
            .connectRetryCount(connectRetryCount?.applyValue({ args0 -> args0 }))
            .connectRetryInterval(connectRetryInterval?.applyValue({ args0 -> args0 }))
            .connectTimeout(connectTimeout?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypt(encrypt?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .failoverPartner(failoverPartner?.applyValue({ args0 -> args0 }))
            .hostNameInCertificate(hostNameInCertificate?.applyValue({ args0 -> args0 }))
            .integratedSecurity(integratedSecurity?.applyValue({ args0 -> args0 }))
            .loadBalanceTimeout(loadBalanceTimeout?.applyValue({ args0 -> args0 }))
            .maxPoolSize(maxPoolSize?.applyValue({ args0 -> args0 }))
            .minPoolSize(minPoolSize?.applyValue({ args0 -> args0 }))
            .multiSubnetFailover(multiSubnetFailover?.applyValue({ args0 -> args0 }))
            .multipleActiveResultSets(multipleActiveResultSets?.applyValue({ args0 -> args0 }))
            .packetSize(packetSize?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .pooling(pooling?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .trustServerCertificate(trustServerCertificate?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonRdsForSqlServerLinkedServiceArgs].
 */
@PulumiTagMarker
public class AmazonRdsForSqlServerLinkedServiceArgsBuilder internal constructor() {
    private var alwaysEncryptedSettings: Output<SqlAlwaysEncryptedPropertiesArgs>? = null

    private var annotations: Output<List<Any>>? = null

    private var applicationIntent: Output<Any>? = null

    private var authenticationType: Output<Either<String, AmazonRdsForSqlAuthenticationType>>? = null

    private var commandTimeout: Output<Any>? = null

    private var connectRetryCount: Output<Any>? = null

    private var connectRetryInterval: Output<Any>? = null

    private var connectTimeout: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encrypt: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var failoverPartner: Output<Any>? = null

    private var hostNameInCertificate: Output<Any>? = null

    private var integratedSecurity: Output<Any>? = null

    private var loadBalanceTimeout: Output<Any>? = null

    private var maxPoolSize: Output<Any>? = null

    private var minPoolSize: Output<Any>? = null

    private var multiSubnetFailover: Output<Any>? = null

    private var multipleActiveResultSets: Output<Any>? = null

    private var packetSize: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var pooling: Output<Any>? = null

    private var server: Output<Any>? = null

    private var trustServerCertificate: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value Sql always encrypted properties.
     */
    @JvmName("hkoovqenppanwkam")
    public suspend fun alwaysEncryptedSettings(`value`: Output<SqlAlwaysEncryptedPropertiesArgs>) {
        this.alwaysEncryptedSettings = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("upfvyqawldtysnxg")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ejfvtsefakajdoqv")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ndlepkamsoxaqlvh")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
     */
    @JvmName("iburrtsgqdinahhc")
    public suspend fun applicationIntent(`value`: Output<Any>) {
        this.applicationIntent = value
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("vpvkesmblqraedja")
    public suspend fun authenticationType(`value`: Output<Either<String, AmazonRdsForSqlAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cvvoncthhjjvyyrr")
    public suspend fun commandTimeout(`value`: Output<Any>) {
        this.commandTimeout = value
    }

    /**
     * @param value The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
     */
    @JvmName("utfvldvdeufvenjt")
    public suspend fun connectRetryCount(`value`: Output<Any>) {
        this.connectRetryCount = value
    }

    /**
     * @param value The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ojffeybdnygoomwk")
    public suspend fun connectRetryInterval(`value`: Output<Any>) {
        this.connectRetryInterval = value
    }

    /**
     * @param value The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ouainsljlbcovjyc")
    public suspend fun connectTimeout(`value`: Output<Any>) {
        this.connectTimeout = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("phbpmtrilxmicnas")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("dksibcbogmrqhcmt")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value The name of the database, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("pbcrmtqcpwqmsynx")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("fkubpamlljfhlnfs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
     */
    @JvmName("klpbiohbaqqsfsgp")
    public suspend fun encrypt(`value`: Output<Any>) {
        this.encrypt = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("jxlkrhxrmtuddoap")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("gwjqmcskywuuerwr")
    public suspend fun failoverPartner(`value`: Output<Any>) {
        this.failoverPartner = value
    }

    /**
     * @param value The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("ksrjfhlykxwdnsnj")
    public suspend fun hostNameInCertificate(`value`: Output<Any>) {
        this.hostNameInCertificate = value
    }

    /**
     * @param value Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("lqfqmndkqlypktem")
    public suspend fun integratedSecurity(`value`: Output<Any>) {
        this.integratedSecurity = value
    }

    /**
     * @param value The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bjyjjsfvukxfjdgw")
    public suspend fun loadBalanceTimeout(`value`: Output<Any>) {
        this.loadBalanceTimeout = value
    }

    /**
     * @param value The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("nobmyjjsajuyckrc")
    public suspend fun maxPoolSize(`value`: Output<Any>) {
        this.maxPoolSize = value
    }

    /**
     * @param value The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ihflcmocusokyirp")
    public suspend fun minPoolSize(`value`: Output<Any>) {
        this.minPoolSize = value
    }

    /**
     * @param value If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("dsthhuopkktgorec")
    public suspend fun multiSubnetFailover(`value`: Output<Any>) {
        this.multiSubnetFailover = value
    }

    /**
     * @param value When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("hbxrcnkrraiqldav")
    public suspend fun multipleActiveResultSets(`value`: Output<Any>) {
        this.multipleActiveResultSets = value
    }

    /**
     * @param value The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("neueoejgykovvtpq")
    public suspend fun packetSize(`value`: Output<Any>) {
        this.packetSize = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("dvpstsheergkixct")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("mrqhlfislkyodwdu")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("jcdfdlqfapdxeimt")
    public suspend fun pooling(`value`: Output<Any>) {
        this.pooling = value
    }

    /**
     * @param value The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("axlndxthlrdftvwo")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("pjagkrhhhqiplowk")
    public suspend fun trustServerCertificate(`value`: Output<Any>) {
        this.trustServerCertificate = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonRdsForSqlServer'.
     */
    @JvmName("kjpbiysjtsfhrtnw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
     */
    @JvmName("juulqofvnccolxqt")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value Sql always encrypted properties.
     */
    @JvmName("tmskflogfxbqddwe")
    public suspend fun alwaysEncryptedSettings(`value`: SqlAlwaysEncryptedPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysEncryptedSettings = mapped
    }

    /**
     * @param argument Sql always encrypted properties.
     */
    @JvmName("lnswyasroxugbskf")
    public suspend fun alwaysEncryptedSettings(argument: suspend SqlAlwaysEncryptedPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SqlAlwaysEncryptedPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alwaysEncryptedSettings = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("gqcffxvrgbrdxodo")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("aokvblpeqwwavlwu")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
     */
    @JvmName("ngvtxdinurwnadtm")
    public suspend fun applicationIntent(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationIntent = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("jwredgniyaqaglfd")
    public suspend fun authenticationType(`value`: Either<String, AmazonRdsForSqlAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("vqrosrggauiqhxfj")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AmazonRdsForSqlAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("jmcytdhbqpcebbak")
    public fun authenticationType(`value`: AmazonRdsForSqlAuthenticationType) {
        val toBeMapped = Either.ofRight<String, AmazonRdsForSqlAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("axmmsxjqmwivvfdk")
    public suspend fun commandTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandTimeout = mapped
    }

    /**
     * @param value The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
     */
    @JvmName("pgrnawgfjbimmoky")
    public suspend fun connectRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectRetryCount = mapped
    }

    /**
     * @param value The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
     */
    @JvmName("eejqugepvsjxxagb")
    public suspend fun connectRetryInterval(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectRetryInterval = mapped
    }

    /**
     * @param value The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("yxqgobrrkmmhjbkc")
    public suspend fun connectTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectTimeout = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ypdwblcqsvisifsq")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("xqhfwjerghfrvxnb")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("wkdqqiulsqxoohqa")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The name of the database, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("qbvromorfcbtxvie")
    public suspend fun database(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("coxwfsnxjdvkbkdl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
     */
    @JvmName("mtcwvmlbwrgyywxe")
    public suspend fun encrypt(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypt = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("uavpsrtdhkxxsqnm")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("vxbbqpebxpcamdpv")
    public suspend fun failoverPartner(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverPartner = mapped
    }

    /**
     * @param value The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("gbglwvfqqyoymeek")
    public suspend fun hostNameInCertificate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNameInCertificate = mapped
    }

    /**
     * @param value Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("nqtwhotqbpbnxagi")
    public suspend fun integratedSecurity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integratedSecurity = mapped
    }

    /**
     * @param value The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("etvbrbwwfqqgiefu")
    public suspend fun loadBalanceTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalanceTimeout = mapped
    }

    /**
     * @param value The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("egubturqnvkkaygr")
    public suspend fun maxPoolSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPoolSize = mapped
    }

    /**
     * @param value The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jwmgwdtitcgrxonc")
    public suspend fun minPoolSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPoolSize = mapped
    }

    /**
     * @param value If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("dqqlfenusvmufeag")
    public suspend fun multiSubnetFailover(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiSubnetFailover = mapped
    }

    /**
     * @param value When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("giythvivekojshse")
    public suspend fun multipleActiveResultSets(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multipleActiveResultSets = mapped
    }

    /**
     * @param value The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rpyinaxsbhojmhta")
    public suspend fun packetSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetSize = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("sfjvbcnfdfphfwog")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("asgspkyexbtqagqu")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("jwsjqgsfmsphyhwv")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("dgidjiqmwggcdqsm")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("nnulghxxmjabftyo")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The on-premises Windows authentication password.
     */
    @JvmName("rbaonvctjfnohydw")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("uocqjsuigdwgfbgn")
    public suspend fun pooling(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pooling = mapped
    }

    /**
     * @param value The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("hvnjcgjleqiwaqsf")
    public suspend fun server(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("mbekihnmcjwxgvyv")
    public suspend fun trustServerCertificate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustServerCertificate = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonRdsForSqlServer'.
     */
    @JvmName("tuqdqlutimmrxosf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
     */
    @JvmName("bpmwhmsrcnetxxuk")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): AmazonRdsForSqlServerLinkedServiceArgs =
        AmazonRdsForSqlServerLinkedServiceArgs(
            alwaysEncryptedSettings = alwaysEncryptedSettings,
            annotations = annotations,
            applicationIntent = applicationIntent,
            authenticationType = authenticationType,
            commandTimeout = commandTimeout,
            connectRetryCount = connectRetryCount,
            connectRetryInterval = connectRetryInterval,
            connectTimeout = connectTimeout,
            connectVia = connectVia,
            connectionString = connectionString,
            database = database,
            description = description,
            encrypt = encrypt,
            encryptedCredential = encryptedCredential,
            failoverPartner = failoverPartner,
            hostNameInCertificate = hostNameInCertificate,
            integratedSecurity = integratedSecurity,
            loadBalanceTimeout = loadBalanceTimeout,
            maxPoolSize = maxPoolSize,
            minPoolSize = minPoolSize,
            multiSubnetFailover = multiSubnetFailover,
            multipleActiveResultSets = multipleActiveResultSets,
            packetSize = packetSize,
            parameters = parameters,
            password = password,
            pooling = pooling,
            server = server,
            trustServerCertificate = trustServerCertificate,
            type = type ?: throw PulumiNullFieldException("type"),
            userName = userName,
        )
}
