@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureMLExecutePipelineActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure ML Execute Pipeline activity.
 * @property continueOnStepFailure Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the continueOnStepFailure property of the published pipeline execution request. Type: boolean (or Expression with resultType boolean).
 * @property dataPathAssignments Dictionary used for changing data path assignments without retraining. Values will be passed in the dataPathAssignments property of the published pipeline execution request. Type: object (or Expression with resultType object).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property experimentName Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the published pipeline execution request. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property mlParentRunId The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published pipeline execution request. Type: string (or Expression with resultType string).
 * @property mlPipelineEndpointId ID of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
 * @property mlPipelineId ID of the published Azure ML pipeline. Type: string (or Expression with resultType string).
 * @property mlPipelineParameters Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters defined in the published pipeline. Values will be passed in the ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression with resultType object).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'AzureMLExecutePipeline'.
 * @property userProperties Activity user properties.
 * @property version Version of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
 */
public data class AzureMLExecutePipelineActivityArgs(
    public val continueOnStepFailure: Output<Any>? = null,
    public val dataPathAssignments: Output<Any>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val experimentName: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val mlParentRunId: Output<Any>? = null,
    public val mlPipelineEndpointId: Output<Any>? = null,
    public val mlPipelineId: Output<Any>? = null,
    public val mlPipelineParameters: Output<Any>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
    public val version: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureMLExecutePipelineActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureMLExecutePipelineActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureMLExecutePipelineActivityArgs.builder()
            .continueOnStepFailure(continueOnStepFailure?.applyValue({ args0 -> args0 }))
            .dataPathAssignments(dataPathAssignments?.applyValue({ args0 -> args0 }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mlParentRunId(mlParentRunId?.applyValue({ args0 -> args0 }))
            .mlPipelineEndpointId(mlPipelineEndpointId?.applyValue({ args0 -> args0 }))
            .mlPipelineId(mlPipelineId?.applyValue({ args0 -> args0 }))
            .mlPipelineParameters(mlPipelineParameters?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMLExecutePipelineActivityArgs].
 */
@PulumiTagMarker
public class AzureMLExecutePipelineActivityArgsBuilder internal constructor() {
    private var continueOnStepFailure: Output<Any>? = null

    private var dataPathAssignments: Output<Any>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var experimentName: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var mlParentRunId: Output<Any>? = null

    private var mlPipelineEndpointId: Output<Any>? = null

    private var mlPipelineId: Output<Any>? = null

    private var mlPipelineParameters: Output<Any>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    private var version: Output<Any>? = null

    /**
     * @param value Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the continueOnStepFailure property of the published pipeline execution request. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("kunmiwmgdcchspju")
    public suspend fun continueOnStepFailure(`value`: Output<Any>) {
        this.continueOnStepFailure = value
    }

    /**
     * @param value Dictionary used for changing data path assignments without retraining. Values will be passed in the dataPathAssignments property of the published pipeline execution request. Type: object (or Expression with resultType object).
     */
    @JvmName("jyhufwbxoqmlwlse")
    public suspend fun dataPathAssignments(`value`: Output<Any>) {
        this.dataPathAssignments = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("lfhkxrexbeckicyb")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("yglxfidhoxypcgyn")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("vyjpfgmusysrppjw")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("ajvyrgswvwywcgjj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the published pipeline execution request. Type: string (or Expression with resultType string).
     */
    @JvmName("onwrfayxebnfuhme")
    public suspend fun experimentName(`value`: Output<Any>) {
        this.experimentName = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("enjdjjbojvjjdfiv")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published pipeline execution request. Type: string (or Expression with resultType string).
     */
    @JvmName("ndmnfmosbyomrowj")
    public suspend fun mlParentRunId(`value`: Output<Any>) {
        this.mlParentRunId = value
    }

    /**
     * @param value ID of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("ndhsprrgreeploup")
    public suspend fun mlPipelineEndpointId(`value`: Output<Any>) {
        this.mlPipelineEndpointId = value
    }

    /**
     * @param value ID of the published Azure ML pipeline. Type: string (or Expression with resultType string).
     */
    @JvmName("nbpgumkbbetlaigk")
    public suspend fun mlPipelineId(`value`: Output<Any>) {
        this.mlPipelineId = value
    }

    /**
     * @param value Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters defined in the published pipeline. Values will be passed in the ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression with resultType object).
     */
    @JvmName("mougcjxslvlsdpox")
    public suspend fun mlPipelineParameters(`value`: Output<Any>) {
        this.mlPipelineParameters = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("pxuvupycbhyhyytv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("ylmdfndbttnnhnot")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("igoyjvnciwpcfolo")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rthrtcjfnlottjma")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'AzureMLExecutePipeline'.
     */
    @JvmName("vthvsnyghiqyqqex")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("fxwmvcpylbtggsdj")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("opqlfoogtdejfxdx")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("wrrfrttoomldexfy")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Version of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("bfivyhegrdbacjbc")
    public suspend fun version(`value`: Output<Any>) {
        this.version = value
    }

    /**
     * @param value Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the continueOnStepFailure property of the published pipeline execution request. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gkfxpoapbhbsxflb")
    public suspend fun continueOnStepFailure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continueOnStepFailure = mapped
    }

    /**
     * @param value Dictionary used for changing data path assignments without retraining. Values will be passed in the dataPathAssignments property of the published pipeline execution request. Type: object (or Expression with resultType object).
     */
    @JvmName("xdesrwynmlpfsbyg")
    public suspend fun dataPathAssignments(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPathAssignments = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("kxnrwneammxotiqv")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("jflxcvjwmfqowhoa")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("cfceqmxghtwcyxkv")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("reedfyfnyqodhlrr")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("fmvjanmlokesbjpc")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("quukyivgpwbnwlom")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the published pipeline execution request. Type: string (or Expression with resultType string).
     */
    @JvmName("ybwpdcfrdwvnenmu")
    public suspend fun experimentName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("hmudryjdqbgatfmk")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("yoyknlypxrmtndhv")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published pipeline execution request. Type: string (or Expression with resultType string).
     */
    @JvmName("jgbsreggphecvumq")
    public suspend fun mlParentRunId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mlParentRunId = mapped
    }

    /**
     * @param value ID of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("oxbjxggjnahgimuv")
    public suspend fun mlPipelineEndpointId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mlPipelineEndpointId = mapped
    }

    /**
     * @param value ID of the published Azure ML pipeline. Type: string (or Expression with resultType string).
     */
    @JvmName("iinboccphujlucmw")
    public suspend fun mlPipelineId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mlPipelineId = mapped
    }

    /**
     * @param value Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters defined in the published pipeline. Values will be passed in the ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression with resultType object).
     */
    @JvmName("voxnghcvrpfqeowk")
    public suspend fun mlPipelineParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mlPipelineParameters = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("xexcbmlepqlixruw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("ynswwqqyaajkydpw")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("fehdjpntyucbfavv")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("cyopsfqywvyfnwva")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("swklarsbdoumwlwx")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("qignesydrmswmbvb")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ocsqdaoohysndggg")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("yjfnihcvhnsfhwod")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("xdcahpterejyutci")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'AzureMLExecutePipeline'.
     */
    @JvmName("lrsiayrjxytvllbe")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("dabsofsdogiaftbj")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("jjatyestudwkiyow")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("hkkufimdvclarvbk")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("rlfpdpwhefulnlpg")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("lltqdncurusmvmlw")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param value Version of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
     */
    @JvmName("rojosliuxkcxmbnt")
    public suspend fun version(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AzureMLExecutePipelineActivityArgs = AzureMLExecutePipelineActivityArgs(
        continueOnStepFailure = continueOnStepFailure,
        dataPathAssignments = dataPathAssignments,
        dependsOn = dependsOn,
        description = description,
        experimentName = experimentName,
        linkedServiceName = linkedServiceName,
        mlParentRunId = mlParentRunId,
        mlPipelineEndpointId = mlPipelineEndpointId,
        mlPipelineId = mlPipelineId,
        mlPipelineParameters = mlPipelineParameters,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
        version = version,
    )
}
