@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.AzureSqlDWAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure SQL Data Warehouse linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property applicationIntent The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
 * @property authenticationType The type used for authentication. Type: string.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property commandTimeout The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property connectRetryCount The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
 * @property connectRetryInterval The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
 * @property connectTimeout The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property credential The credential reference containing authentication information.
 * @property database The name of the database, used by recommended version. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encrypt Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property failoverPartner The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
 * @property hostNameInCertificate The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
 * @property integratedSecurity Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property loadBalanceTimeout The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property maxPoolSize The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property minPoolSize The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property multiSubnetFailover If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property multipleActiveResultSets When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property packetSize The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string.
 * @property pooling Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property server The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
 * @property servicePrincipalCredential The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
 * @property servicePrincipalCredentialType The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against Azure SQL Data Warehouse.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property trustServerCertificate Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
 * @property type Type of linked service.
 * Expected value is 'AzureSqlDW'.
 * @property userName The user name to be used when connecting to server. Type: string (or Expression with resultType string).
 */
public data class AzureSqlDWLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val applicationIntent: Output<Any>? = null,
    public val authenticationType: Output<Either<String, AzureSqlDWAuthenticationType>>? = null,
    public val azureCloudType: Output<Any>? = null,
    public val commandTimeout: Output<Any>? = null,
    public val connectRetryCount: Output<Any>? = null,
    public val connectRetryInterval: Output<Any>? = null,
    public val connectTimeout: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val database: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encrypt: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val failoverPartner: Output<Any>? = null,
    public val hostNameInCertificate: Output<Any>? = null,
    public val integratedSecurity: Output<Any>? = null,
    public val loadBalanceTimeout: Output<Any>? = null,
    public val maxPoolSize: Output<Any>? = null,
    public val minPoolSize: Output<Any>? = null,
    public val multiSubnetFailover: Output<Any>? = null,
    public val multipleActiveResultSets: Output<Any>? = null,
    public val packetSize: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val pooling: Output<Any>? = null,
    public val server: Output<Any>? = null,
    public val servicePrincipalCredential: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalCredentialType: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val tenant: Output<Any>? = null,
    public val trustServerCertificate: Output<Any>? = null,
    public val type: Output<String>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .applicationIntent(applicationIntent?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureCloudType(azureCloudType?.applyValue({ args0 -> args0 }))
            .commandTimeout(commandTimeout?.applyValue({ args0 -> args0 }))
            .connectRetryCount(connectRetryCount?.applyValue({ args0 -> args0 }))
            .connectRetryInterval(connectRetryInterval?.applyValue({ args0 -> args0 }))
            .connectTimeout(connectTimeout?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypt(encrypt?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .failoverPartner(failoverPartner?.applyValue({ args0 -> args0 }))
            .hostNameInCertificate(hostNameInCertificate?.applyValue({ args0 -> args0 }))
            .integratedSecurity(integratedSecurity?.applyValue({ args0 -> args0 }))
            .loadBalanceTimeout(loadBalanceTimeout?.applyValue({ args0 -> args0 }))
            .maxPoolSize(maxPoolSize?.applyValue({ args0 -> args0 }))
            .minPoolSize(minPoolSize?.applyValue({ args0 -> args0 }))
            .multiSubnetFailover(multiSubnetFailover?.applyValue({ args0 -> args0 }))
            .multipleActiveResultSets(multipleActiveResultSets?.applyValue({ args0 -> args0 }))
            .packetSize(packetSize?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(password?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pooling(pooling?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .servicePrincipalCredential(
                servicePrincipalCredential?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalCredentialType(servicePrincipalCredentialType?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .trustServerCertificate(trustServerCertificate?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureSqlDWLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureSqlDWLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var applicationIntent: Output<Any>? = null

    private var authenticationType: Output<Either<String, AzureSqlDWAuthenticationType>>? = null

    private var azureCloudType: Output<Any>? = null

    private var commandTimeout: Output<Any>? = null

    private var connectRetryCount: Output<Any>? = null

    private var connectRetryInterval: Output<Any>? = null

    private var connectTimeout: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encrypt: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var failoverPartner: Output<Any>? = null

    private var hostNameInCertificate: Output<Any>? = null

    private var integratedSecurity: Output<Any>? = null

    private var loadBalanceTimeout: Output<Any>? = null

    private var maxPoolSize: Output<Any>? = null

    private var minPoolSize: Output<Any>? = null

    private var multiSubnetFailover: Output<Any>? = null

    private var multipleActiveResultSets: Output<Any>? = null

    private var packetSize: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var pooling: Output<Any>? = null

    private var server: Output<Any>? = null

    private var servicePrincipalCredential:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalCredentialType: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var tenant: Output<Any>? = null

    private var trustServerCertificate: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("nbjcgamlpkojhqif")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ovfvmeydauoikkds")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("jvqhvqonnfxyisxa")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
     */
    @JvmName("evmigbkbylgyjwml")
    public suspend fun applicationIntent(`value`: Output<Any>) {
        this.applicationIntent = value
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("qqeekaurfpnfdvaf")
    public suspend fun authenticationType(`value`: Output<Either<String, AzureSqlDWAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("nmqicjuupduqxntm")
    public suspend fun azureCloudType(`value`: Output<Any>) {
        this.azureCloudType = value
    }

    /**
     * @param value The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qonxsnvplovuwhyt")
    public suspend fun commandTimeout(`value`: Output<Any>) {
        this.commandTimeout = value
    }

    /**
     * @param value The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
     */
    @JvmName("eobguqepgylrbrre")
    public suspend fun connectRetryCount(`value`: Output<Any>) {
        this.connectRetryCount = value
    }

    /**
     * @param value The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
     */
    @JvmName("wtxyvqwdtjnhgkqt")
    public suspend fun connectRetryInterval(`value`: Output<Any>) {
        this.connectRetryInterval = value
    }

    /**
     * @param value The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qrkymdfxiychksxm")
    public suspend fun connectTimeout(`value`: Output<Any>) {
        this.connectTimeout = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xarwgcsqmjhsrutw")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("eavuoanhbkegkoir")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("wotanfhvbjkjketd")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value The name of the database, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("rhccsihgrloaajgg")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rsiucuusdqphmofk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
     */
    @JvmName("imjgfaumtsqonjye")
    public suspend fun encrypt(`value`: Output<Any>) {
        this.encrypt = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("dmltebmnvvlkgdit")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("iljeqtmxqdkjykbi")
    public suspend fun failoverPartner(`value`: Output<Any>) {
        this.failoverPartner = value
    }

    /**
     * @param value The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("lvnyvvayskwrwuye")
    public suspend fun hostNameInCertificate(`value`: Output<Any>) {
        this.hostNameInCertificate = value
    }

    /**
     * @param value Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("fvcnihaktsiqagkd")
    public suspend fun integratedSecurity(`value`: Output<Any>) {
        this.integratedSecurity = value
    }

    /**
     * @param value The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("wbxntviyrjkhgbcl")
    public suspend fun loadBalanceTimeout(`value`: Output<Any>) {
        this.loadBalanceTimeout = value
    }

    /**
     * @param value The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("krogmkfihurrfnfc")
    public suspend fun maxPoolSize(`value`: Output<Any>) {
        this.maxPoolSize = value
    }

    /**
     * @param value The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("gjojrhaehxmusgyi")
    public suspend fun minPoolSize(`value`: Output<Any>) {
        this.minPoolSize = value
    }

    /**
     * @param value If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("jtucwmnmdveynwvw")
    public suspend fun multiSubnetFailover(`value`: Output<Any>) {
        this.multiSubnetFailover = value
    }

    /**
     * @param value When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("aacmixdbsvaeqcsk")
    public suspend fun multipleActiveResultSets(`value`: Output<Any>) {
        this.multipleActiveResultSets = value
    }

    /**
     * @param value The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("lbtewlthahueooui")
    public suspend fun packetSize(`value`: Output<Any>) {
        this.packetSize = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("bdibxrwxymsdhknd")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("iyvwnprsrfvfxnye")
    public suspend fun password(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.password = value
    }

    /**
     * @param value Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("qgqnhkhqobofywbw")
    public suspend fun pooling(`value`: Output<Any>) {
        this.pooling = value
    }

    /**
     * @param value The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("anacvpcxdycndmha")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("mgihslafhtqynbhk")
    public suspend fun servicePrincipalCredential(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalCredential = value
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
     */
    @JvmName("nsaccamtabifvgfg")
    public suspend fun servicePrincipalCredentialType(`value`: Output<Any>) {
        this.servicePrincipalCredentialType = value
    }

    /**
     * @param value The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("jsxvubrtnehtttrf")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("blnekhkrcpuxldmj")
    public suspend fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("wlfufnljxtnjacyn")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("fuaymbonpiknmbnq")
    public suspend fun trustServerCertificate(`value`: Output<Any>) {
        this.trustServerCertificate = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureSqlDW'.
     */
    @JvmName("lkljodlovpkwsykb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name to be used when connecting to server. Type: string (or Expression with resultType string).
     */
    @JvmName("wtcroewnxywvaymn")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vcjdpklhdaluhocw")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("scjauikremjfwtor")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The application workload type when connecting to a server, used by recommended version. Possible values are ReadOnly and ReadWrite. Type: string (or Expression with resultType string).
     */
    @JvmName("jwmphicvgbuypmnn")
    public suspend fun applicationIntent(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationIntent = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("ygnmnbuhvreankbj")
    public suspend fun authenticationType(`value`: Either<String, AzureSqlDWAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("quhmuekcmramgoei")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSqlDWAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("lisbldoqrhotownh")
    public fun authenticationType(`value`: AzureSqlDWAuthenticationType) {
        val toBeMapped = Either.ofRight<String, AzureSqlDWAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("jiubytysbrvtkrld")
    public suspend fun azureCloudType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCloudType = mapped
    }

    /**
     * @param value The default wait time (in seconds) before terminating the attempt to execute a command and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("korhsrrjhfvojjrp")
    public suspend fun commandTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandTimeout = mapped
    }

    /**
     * @param value The number of re-connections attempted after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 0 and 255. Type: integer (or Expression with resultType integer).
     */
    @JvmName("yqjwgnwukaswrnlr")
    public suspend fun connectRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectRetryCount = mapped
    }

    /**
     * @param value The amount of time (in seconds) between each re-connection attempt after identifying that there was an idle connection failure, used by recommended version. This must be an integer between 1 and 60. Type: integer (or Expression with resultType integer).
     */
    @JvmName("pxhspjdcstlquykl")
    public suspend fun connectRetryInterval(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectRetryInterval = mapped
    }

    /**
     * @param value The length of time (in seconds) to wait for a connection to the server before terminating the attempt and generating an error, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("uvydkgiufbpolcwg")
    public suspend fun connectTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectTimeout = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wkvovmixoxxqwjer")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("uhoupebqnmslxlkk")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("nvvmtkqwxjsfaviv")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("ubtwealthgukpnok")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("okofghjcbpsnvqms")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value The name of the database, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("wxuragmukchngsvy")
    public suspend fun database(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rlemudhfofwskjdr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicate whether TLS encryption is required for all data sent between the client and server, used by recommended version. Possible values are true/yes/mandatory, false/no/optional and strict. Type: string (or Expression with resultType string).
     */
    @JvmName("essoepasmesxwfdc")
    public suspend fun encrypt(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypt = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("vdwrysiuirrotswy")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The name or address of the partner server to connect to if the primary server is down, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("eoxfmcductjkbkfi")
    public suspend fun failoverPartner(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverPartner = mapped
    }

    /**
     * @param value The host name to use when validating the server certificate for the connection. When not specified, the server name from the Data Source is used for certificate validation, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("giahsvitneensqef")
    public suspend fun hostNameInCertificate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNameInCertificate = mapped
    }

    /**
     * @param value Indicate whether User ID and Password are specified in the connection (when false) or whether the current Windows account credentials are used for authentication (when true), used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("eyhguksrvupnmstu")
    public suspend fun integratedSecurity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integratedSecurity = mapped
    }

    /**
     * @param value The minimum time, in seconds, for the connection to live in the connection pool before being destroyed, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rxuxgbhgbisoppgg")
    public suspend fun loadBalanceTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalanceTimeout = mapped
    }

    /**
     * @param value The maximum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mgmvodfkkhbenusl")
    public suspend fun maxPoolSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPoolSize = mapped
    }

    /**
     * @param value The minimum number of connections allowed in the connection pool for this specific connection string, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rhcaessinmviphcx")
    public suspend fun minPoolSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPoolSize = mapped
    }

    /**
     * @param value If your application is connecting to an AlwaysOn availability group (AG) on different subnets, setting MultiSubnetFailover=true provides faster detection of and connection to the (currently) active server, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("xvvadnqcsbnlwusv")
    public suspend fun multiSubnetFailover(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiSubnetFailover = mapped
    }

    /**
     * @param value When true, an application can maintain multiple active result sets (MARS). When false, an application must process or cancel all result sets from one batch before it can execute any other batch on that connection, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("ahashmicoyjavoja")
    public suspend fun multipleActiveResultSets(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multipleActiveResultSets = mapped
    }

    /**
     * @param value The size in bytes of the network packets used to communicate with an instance of server, used by recommended version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("nhdhkbyvprbdysfr")
    public suspend fun packetSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetSize = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ltuehqeajdqnpnuy")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("cmioptncishfsesr")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("cwgfllmlruxwrvrl")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("wcatueaetqmhwvty")
    public suspend fun password(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of password in connection string.
     */
    @JvmName("hftxpwbbybwpdnnc")
    public suspend fun password(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value Indicate whether the connection will be pooled or explicitly opened every time that the connection is requested, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("wgjowtbsjmnoxoht")
    public suspend fun pooling(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pooling = mapped
    }

    /**
     * @param value The name or network address of the instance of SQL Server to which to connect, used by recommended version. Type: string (or Expression with resultType string).
     */
    @JvmName("wprsiiwrymxyijyu")
    public suspend fun server(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("joumbylvkoeapyjn")
    public suspend fun servicePrincipalCredential(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("qgeaskjxyntkgxkh")
    public fun servicePrincipalCredential(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("lvbwwntlqffqcvwl")
    public fun servicePrincipalCredential(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
     */
    @JvmName("wpqrifdlbiidjmwr")
    public suspend fun servicePrincipalCredentialType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredentialType = mapped
    }

    /**
     * @param value The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("wnndkqijjhnyrvvi")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("iuarjlhodeqbeoud")
    public suspend fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("vrvrfupmifxdnbqx")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("oulgrhtycsluamvk")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("vwpbtjgjdnnxiihu")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Indicate whether the channel will be encrypted while bypassing walking the certificate chain to validate trust, used by recommended version. Type: Boolean (or Expression with resultType boolean).
     */
    @JvmName("ivynpstjhjxoeiwu")
    public suspend fun trustServerCertificate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustServerCertificate = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureSqlDW'.
     */
    @JvmName("pqfgtrefuilubpgp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name to be used when connecting to server. Type: string (or Expression with resultType string).
     */
    @JvmName("sfmfnhayohbghfkl")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): AzureSqlDWLinkedServiceArgs = AzureSqlDWLinkedServiceArgs(
        annotations = annotations,
        applicationIntent = applicationIntent,
        authenticationType = authenticationType,
        azureCloudType = azureCloudType,
        commandTimeout = commandTimeout,
        connectRetryCount = connectRetryCount,
        connectRetryInterval = connectRetryInterval,
        connectTimeout = connectTimeout,
        connectVia = connectVia,
        connectionString = connectionString,
        credential = credential,
        database = database,
        description = description,
        encrypt = encrypt,
        encryptedCredential = encryptedCredential,
        failoverPartner = failoverPartner,
        hostNameInCertificate = hostNameInCertificate,
        integratedSecurity = integratedSecurity,
        loadBalanceTimeout = loadBalanceTimeout,
        maxPoolSize = maxPoolSize,
        minPoolSize = minPoolSize,
        multiSubnetFailover = multiSubnetFailover,
        multipleActiveResultSets = multipleActiveResultSets,
        packetSize = packetSize,
        parameters = parameters,
        password = password,
        pooling = pooling,
        server = server,
        servicePrincipalCredential = servicePrincipalCredential,
        servicePrincipalCredentialType = servicePrincipalCredentialType,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        trustServerCertificate = trustServerCertificate,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
