@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureTableSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Azure Table sink.
 * @property azureTableDefaultPartitionKeyValue Azure Table default partition key value. Type: string (or Expression with resultType string).
 * @property azureTableInsertType Azure Table insert type. Type: string (or Expression with resultType string).
 * @property azureTablePartitionKeyName Azure Table partition key name. Type: string (or Expression with resultType string).
 * @property azureTableRowKeyName Azure Table row key name. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'AzureTableSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class AzureTableSinkArgs(
    public val azureTableDefaultPartitionKeyValue: Output<Any>? = null,
    public val azureTableInsertType: Output<Any>? = null,
    public val azureTablePartitionKeyName: Output<Any>? = null,
    public val azureTableRowKeyName: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureTableSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureTableSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureTableSinkArgs.builder()
            .azureTableDefaultPartitionKeyValue(
                azureTableDefaultPartitionKeyValue?.applyValue({ args0 ->
                    args0
                }),
            )
            .azureTableInsertType(azureTableInsertType?.applyValue({ args0 -> args0 }))
            .azureTablePartitionKeyName(azureTablePartitionKeyName?.applyValue({ args0 -> args0 }))
            .azureTableRowKeyName(azureTableRowKeyName?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureTableSinkArgs].
 */
@PulumiTagMarker
public class AzureTableSinkArgsBuilder internal constructor() {
    private var azureTableDefaultPartitionKeyValue: Output<Any>? = null

    private var azureTableInsertType: Output<Any>? = null

    private var azureTablePartitionKeyName: Output<Any>? = null

    private var azureTableRowKeyName: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    /**
     * @param value Azure Table default partition key value. Type: string (or Expression with resultType string).
     */
    @JvmName("enfcveqotyiiswqs")
    public suspend fun azureTableDefaultPartitionKeyValue(`value`: Output<Any>) {
        this.azureTableDefaultPartitionKeyValue = value
    }

    /**
     * @param value Azure Table insert type. Type: string (or Expression with resultType string).
     */
    @JvmName("pdwqbnsmaecsovyr")
    public suspend fun azureTableInsertType(`value`: Output<Any>) {
        this.azureTableInsertType = value
    }

    /**
     * @param value Azure Table partition key name. Type: string (or Expression with resultType string).
     */
    @JvmName("qpwsonipiwfetwwb")
    public suspend fun azureTablePartitionKeyName(`value`: Output<Any>) {
        this.azureTablePartitionKeyName = value
    }

    /**
     * @param value Azure Table row key name. Type: string (or Expression with resultType string).
     */
    @JvmName("grbusqimprqkietq")
    public suspend fun azureTableRowKeyName(`value`: Output<Any>) {
        this.azureTableRowKeyName = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("hwvpcsxtoxidjpcx")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("wiqfuldwxkdxbemg")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ckpvnkjahpjxckrl")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kprspjkhvgpixohh")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'AzureTableSink'.
     */
    @JvmName("kylkajybesohhxsk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("tmhlxxlghyfiqmbx")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("xlxtefsdoxpvusba")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value Azure Table default partition key value. Type: string (or Expression with resultType string).
     */
    @JvmName("wicrafkgnomcgakc")
    public suspend fun azureTableDefaultPartitionKeyValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTableDefaultPartitionKeyValue = mapped
    }

    /**
     * @param value Azure Table insert type. Type: string (or Expression with resultType string).
     */
    @JvmName("owpnhpigrlhsedkx")
    public suspend fun azureTableInsertType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTableInsertType = mapped
    }

    /**
     * @param value Azure Table partition key name. Type: string (or Expression with resultType string).
     */
    @JvmName("icoouhtjujqevovw")
    public suspend fun azureTablePartitionKeyName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTablePartitionKeyName = mapped
    }

    /**
     * @param value Azure Table row key name. Type: string (or Expression with resultType string).
     */
    @JvmName("swaorurldwdskoqp")
    public suspend fun azureTableRowKeyName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTableRowKeyName = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("kdikjgktmalgdoug")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("sdyyswftwnchdyhp")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("myrajcgxysiumkwk")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("qooxkrsqyudkqywb")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'AzureTableSink'.
     */
    @JvmName("agbyyyjlkkuavbrp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("tlkgxqqiuiujsogv")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("fvqmiouysupfxxhu")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    internal fun build(): AzureTableSinkArgs = AzureTableSinkArgs(
        azureTableDefaultPartitionKeyValue = azureTableDefaultPartitionKeyValue,
        azureTableInsertType = azureTableInsertType,
        azureTablePartitionKeyName = azureTablePartitionKeyName,
        azureTableRowKeyName = azureTableRowKeyName,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
    )
}
