@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.BigDataPoolParametrizationReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.BigDataPoolReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Big data pool reference type.
 * @property referenceName Reference big data pool name. Type: string (or Expression with resultType string).
 * @property type Big data pool reference type.
 */
public data class BigDataPoolParametrizationReferenceArgs(
    public val referenceName: Output<Any>,
    public val type: Output<Either<String, BigDataPoolReferenceType>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.BigDataPoolParametrizationReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.BigDataPoolParametrizationReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.BigDataPoolParametrizationReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BigDataPoolParametrizationReferenceArgs].
 */
@PulumiTagMarker
public class BigDataPoolParametrizationReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<Any>? = null

    private var type: Output<Either<String, BigDataPoolReferenceType>>? = null

    /**
     * @param value Reference big data pool name. Type: string (or Expression with resultType string).
     */
    @JvmName("gfxdabmqdymjbban")
    public suspend fun referenceName(`value`: Output<Any>) {
        this.referenceName = value
    }

    /**
     * @param value Big data pool reference type.
     */
    @JvmName("rjjglnktlnwbojax")
    public suspend fun type(`value`: Output<Either<String, BigDataPoolReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference big data pool name. Type: string (or Expression with resultType string).
     */
    @JvmName("hndammqcrxlmarsp")
    public suspend fun referenceName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Big data pool reference type.
     */
    @JvmName("swwgcgkrhyfxsdyv")
    public suspend fun type(`value`: Either<String, BigDataPoolReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Big data pool reference type.
     */
    @JvmName("phikntucfobdqhyi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BigDataPoolReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Big data pool reference type.
     */
    @JvmName("axolnpcgikwopsip")
    public fun type(`value`: BigDataPoolReferenceType) {
        val toBeMapped = Either.ofRight<String, BigDataPoolReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BigDataPoolParametrizationReferenceArgs =
        BigDataPoolParametrizationReferenceArgs(
            referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
