@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.BinaryReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Binary read settings.
 * @property compressionProperties Compression settings.
 * @property type The read setting type.
 * Expected value is 'BinaryReadSettings'.
 */
public data class BinaryReadSettingsArgs(
    public val compressionProperties: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.BinaryReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.BinaryReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.BinaryReadSettingsArgs.builder()
            .compressionProperties(compressionProperties?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BinaryReadSettingsArgs].
 */
@PulumiTagMarker
public class BinaryReadSettingsArgsBuilder internal constructor() {
    private var compressionProperties: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Compression settings.
     */
    @JvmName("dvnomleiyxtlvhxs")
    public suspend fun compressionProperties(`value`: Output<Any>) {
        this.compressionProperties = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'BinaryReadSettings'.
     */
    @JvmName("ubvphjxvdafvxyhv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Compression settings.
     */
    @JvmName("gusbgvrcpnklfajx")
    public suspend fun compressionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionProperties = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'BinaryReadSettings'.
     */
    @JvmName("yhhlwayhixrsytgv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BinaryReadSettingsArgs = BinaryReadSettingsArgs(
        compressionProperties = compressionProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
