@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.BlobTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that runs every time the selected Blob container changes.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property folderPath The path of the container/folder that will trigger the pipeline.
 * @property linkedService The Azure Storage linked service reference.
 * @property maxConcurrency The max number of parallel files to handle when it is triggered.
 * @property pipelines Pipelines that need to be started.
 * @property type Trigger type.
 * Expected value is 'BlobTrigger'.
 */
public data class BlobTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folderPath: Output<String>,
    public val linkedService: Output<LinkedServiceReferenceArgs>,
    public val maxConcurrency: Output<Int>,
    public val pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.BlobTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.BlobTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.BlobTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath.applyValue({ args0 -> args0 }))
            .linkedService(linkedService.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxConcurrency(maxConcurrency.applyValue({ args0 -> args0 }))
            .pipelines(
                pipelines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobTriggerArgs].
 */
@PulumiTagMarker
public class BlobTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folderPath: Output<String>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    private var maxConcurrency: Output<Int>? = null

    private var pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("kxqvukgtbbjstdov")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("cuipuibhmwkqkkoi")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("hbdtgqbqrhbcwifk")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("gtdqwxhubrpjgmjs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The path of the container/folder that will trigger the pipeline.
     */
    @JvmName("qtcpectfbnvkyile")
    public suspend fun folderPath(`value`: Output<String>) {
        this.folderPath = value
    }

    /**
     * @param value The Azure Storage linked service reference.
     */
    @JvmName("vlhlulhjokxuvbsk")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value The max number of parallel files to handle when it is triggered.
     */
    @JvmName("pegtwddjsfdeffqr")
    public suspend fun maxConcurrency(`value`: Output<Int>) {
        this.maxConcurrency = value
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("cfwiwarkekguiptc")
    public suspend fun pipelines(`value`: Output<List<TriggerPipelineReferenceArgs>>) {
        this.pipelines = value
    }

    @JvmName("mdvusskhcepbrqjv")
    public suspend fun pipelines(vararg values: Output<TriggerPipelineReferenceArgs>) {
        this.pipelines = Output.all(values.asList())
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("xhycspamdrmekykm")
    public suspend fun pipelines(values: List<Output<TriggerPipelineReferenceArgs>>) {
        this.pipelines = Output.all(values)
    }

    /**
     * @param value Trigger type.
     * Expected value is 'BlobTrigger'.
     */
    @JvmName("cglfmsuasaaqjdxk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("mtsyhxieqqpldiao")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("ltpojtqgvngxgwok")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("gjgbrnpcqnxcjcmf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The path of the container/folder that will trigger the pipeline.
     */
    @JvmName("camrnvrqmhroyktr")
    public suspend fun folderPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value The Azure Storage linked service reference.
     */
    @JvmName("pecasslpomrfgjbv")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument The Azure Storage linked service reference.
     */
    @JvmName("grgiwwhlwadjuojb")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    /**
     * @param value The max number of parallel files to handle when it is triggered.
     */
    @JvmName("ttqiqkvgglfqpvur")
    public suspend fun maxConcurrency(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("knqjipyvhrxgmjiw")
    public suspend fun pipelines(`value`: List<TriggerPipelineReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("ltcqmkhjqbybugtj")
    public suspend fun pipelines(argument: List<suspend TriggerPipelineReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("mxylfhmixhjrsgpf")
    public suspend fun pipelines(vararg argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("vuqyxnmnpgoaudgt")
    public suspend fun pipelines(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("pptovuhlxruiqjcm")
    public suspend fun pipelines(vararg values: TriggerPipelineReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'BlobTrigger'.
     */
    @JvmName("pgeibnlghhwxoucq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobTriggerArgs = BlobTriggerArgs(
        annotations = annotations,
        description = description,
        folderPath = folderPath ?: throw PulumiNullFieldException("folderPath"),
        linkedService = linkedService ?: throw PulumiNullFieldException("linkedService"),
        maxConcurrency = maxConcurrency ?: throw PulumiNullFieldException("maxConcurrency"),
        pipelines = pipelines,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
