@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CmdkeySetupArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The custom setup of running cmdkey commands.
 * @property password The password of data source access.
 * @property targetName The server name of data source access. Type: string.
 * @property type The type of custom setup.
 * Expected value is 'CmdkeySetup'.
 * @property userName The user name of data source access. Type: string.
 */
public data class CmdkeySetupArgs(
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val targetName: Output<Any>,
    public val type: Output<String>,
    public val userName: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CmdkeySetupArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CmdkeySetupArgs =
        com.pulumi.azurenative.datafactory.inputs.CmdkeySetupArgs.builder()
            .password(
                password.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetName(targetName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CmdkeySetupArgs].
 */
@PulumiTagMarker
public class CmdkeySetupArgsBuilder internal constructor() {
    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var targetName: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value The password of data source access.
     */
    @JvmName("mbrumiylbinnuost")
    public suspend fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The server name of data source access. Type: string.
     */
    @JvmName("ktkedmekngycpqnn")
    public suspend fun targetName(`value`: Output<Any>) {
        this.targetName = value
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'CmdkeySetup'.
     */
    @JvmName("blesadmdwjimhiki")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name of data source access. Type: string.
     */
    @JvmName("nswugierjbnkmxpo")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value The password of data source access.
     */
    @JvmName("ykqtvsfdxoebrvtk")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password of data source access.
     */
    @JvmName("igmqllgokabnmkqo")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password of data source access.
     */
    @JvmName("tcqsjgxthgeueveq")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The server name of data source access. Type: string.
     */
    @JvmName("icqxxbpfaomghrxv")
    public suspend fun targetName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'CmdkeySetup'.
     */
    @JvmName("tefagigiamckkaug")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name of data source access. Type: string.
     */
    @JvmName("nvwqjvsajpsrjuop")
    public suspend fun userName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): CmdkeySetupArgs = CmdkeySetupArgs(
        password = password ?: throw PulumiNullFieldException("password"),
        targetName = targetName ?: throw PulumiNullFieldException("targetName"),
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
