@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ComponentSetupArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The custom setup of installing 3rd party components.
 * @property componentName The name of the 3rd party component.
 * @property licenseKey The license key to activate the component.
 * @property type The type of custom setup.
 * Expected value is 'ComponentSetup'.
 */
public data class ComponentSetupArgs(
    public val componentName: Output<String>,
    public val licenseKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ComponentSetupArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ComponentSetupArgs =
        com.pulumi.azurenative.datafactory.inputs.ComponentSetupArgs.builder()
            .componentName(componentName.applyValue({ args0 -> args0 }))
            .licenseKey(
                licenseKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentSetupArgs].
 */
@PulumiTagMarker
public class ComponentSetupArgsBuilder internal constructor() {
    private var componentName: Output<String>? = null

    private var licenseKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the 3rd party component.
     */
    @JvmName("safgjkhevwetmwaj")
    public suspend fun componentName(`value`: Output<String>) {
        this.componentName = value
    }

    /**
     * @param value The license key to activate the component.
     */
    @JvmName("ahskogqrasuvgpym")
    public suspend fun licenseKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.licenseKey = value
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'ComponentSetup'.
     */
    @JvmName("nhvgylpfcwgjyoip")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the 3rd party component.
     */
    @JvmName("rkrjdorlphsfbbcc")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value The license key to activate the component.
     */
    @JvmName("oeuttyyuokcxfarc")
    public suspend fun licenseKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseKey = mapped
    }

    /**
     * @param value The license key to activate the component.
     */
    @JvmName("maedxoctieynirnt")
    public fun licenseKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseKey = mapped
    }

    /**
     * @param value The license key to activate the component.
     */
    @JvmName("vdgggimomkssyysb")
    public fun licenseKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseKey = mapped
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'ComponentSetup'.
     */
    @JvmName("odkxnepbnuijsqbi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ComponentSetupArgs = ComponentSetupArgs(
        componentName = componentName ?: throw PulumiNullFieldException("componentName"),
        licenseKey = licenseKey,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
