@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CopyActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Copy activity.
 * @property dataIntegrationUnits Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property enableSkipIncompatibleRow Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property enableStaging Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property inputs List of inputs for the activity.
 * @property linkedServiceName Linked service reference.
 * @property logSettings Log settings customer needs provide when enabling log.
 * @property logStorageSettings (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property outputs List of outputs for the activity.
 * @property parallelCopies Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property policy Activity policy.
 * @property preserve Preserve rules.
 * @property preserveRules Preserve Rules.
 * @property redirectIncompatibleRowSettings Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
 * @property sink Copy activity sink.
 * @property skipErrorFile Specify the fault tolerance for data consistency.
 * @property source Copy activity source.
 * @property stagingSettings Specifies interim staging settings when EnableStaging is true.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property translator Copy activity translator. If not specified, tabular translator is used.
 * @property type Type of activity.
 * Expected value is 'Copy'.
 * @property userProperties Activity user properties.
 * @property validateDataConsistency Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean).
 */
public data class CopyActivityArgs(
    public val dataIntegrationUnits: Output<Any>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val enableSkipIncompatibleRow: Output<Any>? = null,
    public val enableStaging: Output<Any>? = null,
    public val inputs: Output<List<DatasetReferenceArgs>>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val logSettings: Output<LogSettingsArgs>? = null,
    public val logStorageSettings: Output<LogStorageSettingsArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val outputs: Output<List<DatasetReferenceArgs>>? = null,
    public val parallelCopies: Output<Any>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val preserve: Output<List<Any>>? = null,
    public val preserveRules: Output<List<Any>>? = null,
    public val redirectIncompatibleRowSettings: Output<RedirectIncompatibleRowSettingsArgs>? = null,
    public val sink: Output<Any>,
    public val skipErrorFile: Output<SkipErrorFileArgs>? = null,
    public val source: Output<Any>,
    public val stagingSettings: Output<StagingSettingsArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val translator: Output<Any>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
    public val validateDataConsistency: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CopyActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CopyActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.CopyActivityArgs.builder()
            .dataIntegrationUnits(dataIntegrationUnits?.applyValue({ args0 -> args0 }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .enableSkipIncompatibleRow(enableSkipIncompatibleRow?.applyValue({ args0 -> args0 }))
            .enableStaging(enableStaging?.applyValue({ args0 -> args0 }))
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logSettings(logSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logStorageSettings(
                logStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parallelCopies(parallelCopies?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preserve(preserve?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .preserveRules(preserveRules?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .redirectIncompatibleRowSettings(
                redirectIncompatibleRowSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sink(sink.applyValue({ args0 -> args0 }))
            .skipErrorFile(skipErrorFile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .source(source.applyValue({ args0 -> args0 }))
            .stagingSettings(stagingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .translator(translator?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .validateDataConsistency(validateDataConsistency?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopyActivityArgs].
 */
@PulumiTagMarker
public class CopyActivityArgsBuilder internal constructor() {
    private var dataIntegrationUnits: Output<Any>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var enableSkipIncompatibleRow: Output<Any>? = null

    private var enableStaging: Output<Any>? = null

    private var inputs: Output<List<DatasetReferenceArgs>>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var logSettings: Output<LogSettingsArgs>? = null

    private var logStorageSettings: Output<LogStorageSettingsArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var outputs: Output<List<DatasetReferenceArgs>>? = null

    private var parallelCopies: Output<Any>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var preserve: Output<List<Any>>? = null

    private var preserveRules: Output<List<Any>>? = null

    private var redirectIncompatibleRowSettings: Output<RedirectIncompatibleRowSettingsArgs>? = null

    private var sink: Output<Any>? = null

    private var skipErrorFile: Output<SkipErrorFileArgs>? = null

    private var source: Output<Any>? = null

    private var stagingSettings: Output<StagingSettingsArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var translator: Output<Any>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    private var validateDataConsistency: Output<Any>? = null

    /**
     * @param value Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("qvprqgjtgkjmwpcn")
    public suspend fun dataIntegrationUnits(`value`: Output<Any>) {
        this.dataIntegrationUnits = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("rtkpppwwsoaqvvtk")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("lnqmkdcktpuyemea")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("xialqrisusagkcwi")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("ifsvaivdjlkrysyw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("pefhanxpmbhkiddf")
    public suspend fun enableSkipIncompatibleRow(`value`: Output<Any>) {
        this.enableSkipIncompatibleRow = value
    }

    /**
     * @param value Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("dqrlpfbxnaxoeers")
    public suspend fun enableStaging(`value`: Output<Any>) {
        this.enableStaging = value
    }

    /**
     * @param value List of inputs for the activity.
     */
    @JvmName("qabjnatxracxjlks")
    public suspend fun inputs(`value`: Output<List<DatasetReferenceArgs>>) {
        this.inputs = value
    }

    @JvmName("ghfujoyhaejumdpa")
    public suspend fun inputs(vararg values: Output<DatasetReferenceArgs>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values List of inputs for the activity.
     */
    @JvmName("ykydrprybpxvdiks")
    public suspend fun inputs(values: List<Output<DatasetReferenceArgs>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("cisbqdcovgkjtity")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Log settings customer needs provide when enabling log.
     */
    @JvmName("givufblilnuptsuk")
    public suspend fun logSettings(`value`: Output<LogSettingsArgs>) {
        this.logSettings = value
    }

    /**
     * @param value (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
     */
    @JvmName("ktpycgfofbwutghb")
    public suspend fun logStorageSettings(`value`: Output<LogStorageSettingsArgs>) {
        this.logStorageSettings = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("pdokxtyelpeooril")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("mwabebvufpijwdkc")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value List of outputs for the activity.
     */
    @JvmName("apdkqknvlhjeajcu")
    public suspend fun outputs(`value`: Output<List<DatasetReferenceArgs>>) {
        this.outputs = value
    }

    @JvmName("ubsrhnmoqmrhslor")
    public suspend fun outputs(vararg values: Output<DatasetReferenceArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values List of outputs for the activity.
     */
    @JvmName("qfdyhwcoaoagngyb")
    public suspend fun outputs(values: List<Output<DatasetReferenceArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("lbxqymfhhxiikkki")
    public suspend fun parallelCopies(`value`: Output<Any>) {
        this.parallelCopies = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("gpxouybdpifbmhsc")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Preserve rules.
     */
    @JvmName("uhojkawvdycisxtg")
    public suspend fun preserve(`value`: Output<List<Any>>) {
        this.preserve = value
    }

    @JvmName("awmdlgldyhgbtxhw")
    public suspend fun preserve(vararg values: Output<Any>) {
        this.preserve = Output.all(values.asList())
    }

    /**
     * @param values Preserve rules.
     */
    @JvmName("sphsejpesqwkheqd")
    public suspend fun preserve(values: List<Output<Any>>) {
        this.preserve = Output.all(values)
    }

    /**
     * @param value Preserve Rules.
     */
    @JvmName("ljunuaaetgdmbvnv")
    public suspend fun preserveRules(`value`: Output<List<Any>>) {
        this.preserveRules = value
    }

    @JvmName("cdsxgnganbitmmvj")
    public suspend fun preserveRules(vararg values: Output<Any>) {
        this.preserveRules = Output.all(values.asList())
    }

    /**
     * @param values Preserve Rules.
     */
    @JvmName("mmmbdgsswnhcuaup")
    public suspend fun preserveRules(values: List<Output<Any>>) {
        this.preserveRules = Output.all(values)
    }

    /**
     * @param value Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
     */
    @JvmName("ejqsrvckrimlqtnr")
    public suspend fun redirectIncompatibleRowSettings(`value`: Output<RedirectIncompatibleRowSettingsArgs>) {
        this.redirectIncompatibleRowSettings = value
    }

    /**
     * @param value Copy activity sink.
     */
    @JvmName("rfqtwwoompjlgleu")
    public suspend fun sink(`value`: Output<Any>) {
        this.sink = value
    }

    /**
     * @param value Specify the fault tolerance for data consistency.
     */
    @JvmName("gsymtssamhrflusp")
    public suspend fun skipErrorFile(`value`: Output<SkipErrorFileArgs>) {
        this.skipErrorFile = value
    }

    /**
     * @param value Copy activity source.
     */
    @JvmName("qivhubaikamdmfwn")
    public suspend fun source(`value`: Output<Any>) {
        this.source = value
    }

    /**
     * @param value Specifies interim staging settings when EnableStaging is true.
     */
    @JvmName("xmkrqdaqkbkcqgcv")
    public suspend fun stagingSettings(`value`: Output<StagingSettingsArgs>) {
        this.stagingSettings = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("mpmekfinhsmqfnqp")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Copy activity translator. If not specified, tabular translator is used.
     */
    @JvmName("vuyktqqpxxjufold")
    public suspend fun translator(`value`: Output<Any>) {
        this.translator = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Copy'.
     */
    @JvmName("icooqbinrebqsyxr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("mkmcicgshmyqodck")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("cesxcdklrbsbqhfj")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("naulcrwsxeypnfor")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("grgvuwsyidqnecpk")
    public suspend fun validateDataConsistency(`value`: Output<Any>) {
        this.validateDataConsistency = value
    }

    /**
     * @param value Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("ygvemojlabsntdxb")
    public suspend fun dataIntegrationUnits(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataIntegrationUnits = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("tdohuoesgwdpsnwg")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("ngepmpaqawtlmiff")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("umwachuophkuuovg")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("dnjqukwtrmigsbcl")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("imtrqwtwerekgngw")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("mrqnjqqgnlnwgeiv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ccvxlhbmavsjgkly")
    public suspend fun enableSkipIncompatibleRow(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSkipIncompatibleRow = mapped
    }

    /**
     * @param value Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("prdylxjvlvdpxvqe")
    public suspend fun enableStaging(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStaging = mapped
    }

    /**
     * @param value List of inputs for the activity.
     */
    @JvmName("msbokmchsojcuhqm")
    public suspend fun inputs(`value`: List<DatasetReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument List of inputs for the activity.
     */
    @JvmName("okpoinkrpwvrxrhr")
    public suspend fun inputs(argument: List<suspend DatasetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument List of inputs for the activity.
     */
    @JvmName("ihshvylgeqipioix")
    public suspend fun inputs(vararg argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument List of inputs for the activity.
     */
    @JvmName("jvfbiilqsvcgpsxb")
    public suspend fun inputs(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatasetReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param values List of inputs for the activity.
     */
    @JvmName("qsptnfpoxbmxocmv")
    public suspend fun inputs(vararg values: DatasetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("xsfvmyfcprwjkwyw")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("fsubjnytrakrfftu")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Log settings customer needs provide when enabling log.
     */
    @JvmName("pajwetwfacugnxip")
    public suspend fun logSettings(`value`: LogSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logSettings = mapped
    }

    /**
     * @param argument Log settings customer needs provide when enabling log.
     */
    @JvmName("anhmncsasqprgovo")
    public suspend fun logSettings(argument: suspend LogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LogSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logSettings = mapped
    }

    /**
     * @param value (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
     */
    @JvmName("mkuskvopkqlsygml")
    public suspend fun logStorageSettings(`value`: LogStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorageSettings = mapped
    }

    /**
     * @param argument (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
     */
    @JvmName("mtkarponhwwcbdca")
    public suspend fun logStorageSettings(argument: suspend LogStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LogStorageSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logStorageSettings = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("ubmvpwilwjypqyfu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("uckqwqgefsdakfbv")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("yoljjdmqgejgbjkl")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("oqujiqhdtfavoadp")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value List of outputs for the activity.
     */
    @JvmName("wtbftkowequqjgsx")
    public suspend fun outputs(`value`: List<DatasetReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument List of outputs for the activity.
     */
    @JvmName("jrxtejtrykhginmn")
    public suspend fun outputs(argument: List<suspend DatasetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument List of outputs for the activity.
     */
    @JvmName("vyxhrcmpskupmtve")
    public suspend fun outputs(vararg argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument List of outputs for the activity.
     */
    @JvmName("wiqnhcyatftdujwo")
    public suspend fun outputs(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatasetReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values List of outputs for the activity.
     */
    @JvmName("rvkqhmykfoppnnkg")
    public suspend fun outputs(vararg values: DatasetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("khikgrgorriqdgyo")
    public suspend fun parallelCopies(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelCopies = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("fqxyuxyxjfcbmmwo")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("pvgnxhpfdooendfl")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Preserve rules.
     */
    @JvmName("vbvqklnuyxxehfgi")
    public suspend fun preserve(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserve = mapped
    }

    /**
     * @param values Preserve rules.
     */
    @JvmName("auplfnuqieejipyy")
    public suspend fun preserve(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preserve = mapped
    }

    /**
     * @param value Preserve Rules.
     */
    @JvmName("drqlpcwlxenknebt")
    public suspend fun preserveRules(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveRules = mapped
    }

    /**
     * @param values Preserve Rules.
     */
    @JvmName("kqgbxkkqrtpqoani")
    public suspend fun preserveRules(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preserveRules = mapped
    }

    /**
     * @param value Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
     */
    @JvmName("gbdbocibrsrsbtph")
    public suspend fun redirectIncompatibleRowSettings(`value`: RedirectIncompatibleRowSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectIncompatibleRowSettings = mapped
    }

    /**
     * @param argument Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
     */
    @JvmName("rhukboxrexmejlvm")
    public suspend fun redirectIncompatibleRowSettings(argument: suspend RedirectIncompatibleRowSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RedirectIncompatibleRowSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirectIncompatibleRowSettings = mapped
    }

    /**
     * @param value Copy activity sink.
     */
    @JvmName("irfkkotwtieldpko")
    public suspend fun sink(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sink = mapped
    }

    /**
     * @param value Specify the fault tolerance for data consistency.
     */
    @JvmName("rhcdlmqiryjbhtyl")
    public suspend fun skipErrorFile(`value`: SkipErrorFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipErrorFile = mapped
    }

    /**
     * @param argument Specify the fault tolerance for data consistency.
     */
    @JvmName("ftehlxcevpuqkaem")
    public suspend fun skipErrorFile(argument: suspend SkipErrorFileArgsBuilder.() -> Unit) {
        val toBeMapped = SkipErrorFileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.skipErrorFile = mapped
    }

    /**
     * @param value Copy activity source.
     */
    @JvmName("xkcegshhespseopp")
    public suspend fun source(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Specifies interim staging settings when EnableStaging is true.
     */
    @JvmName("wgyagckmiphcidwi")
    public suspend fun stagingSettings(`value`: StagingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingSettings = mapped
    }

    /**
     * @param argument Specifies interim staging settings when EnableStaging is true.
     */
    @JvmName("eleectenldmqnbkh")
    public suspend fun stagingSettings(argument: suspend StagingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StagingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stagingSettings = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("oblwgxnqoyxuyhpb")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("vjgahitllxpblqeh")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("lhsckikvvsqnadcf")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Copy activity translator. If not specified, tabular translator is used.
     */
    @JvmName("bjffreasyofksgve")
    public suspend fun translator(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translator = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Copy'.
     */
    @JvmName("pnegapuesmmmyqdg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("fetixdqhremxqlbx")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("awmjcsksmroeerek")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("utgcxaniwgarvqpe")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("horsclpjfjygbyke")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("ixeknxqvfefitqni")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param value Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vvjytkbgaqbtglnj")
    public suspend fun validateDataConsistency(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateDataConsistency = mapped
    }

    internal fun build(): CopyActivityArgs = CopyActivityArgs(
        dataIntegrationUnits = dataIntegrationUnits,
        dependsOn = dependsOn,
        description = description,
        enableSkipIncompatibleRow = enableSkipIncompatibleRow,
        enableStaging = enableStaging,
        inputs = inputs,
        linkedServiceName = linkedServiceName,
        logSettings = logSettings,
        logStorageSettings = logStorageSettings,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        outputs = outputs,
        parallelCopies = parallelCopies,
        policy = policy,
        preserve = preserve,
        preserveRules = preserveRules,
        redirectIncompatibleRowSettings = redirectIncompatibleRowSettings,
        sink = sink ?: throw PulumiNullFieldException("sink"),
        skipErrorFile = skipErrorFile,
        source = source ?: throw PulumiNullFieldException("source"),
        stagingSettings = stagingSettings,
        state = state,
        translator = translator,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
        validateDataConsistency = validateDataConsistency,
    )
}
