@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CopyComputeScalePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CopyComputeScale properties for managed integration runtime.
 * @property dataIntegrationUnit DIU number setting reserved for copy activity execution. Supported values are multiples of 4 in range 4-256.
 * @property timeToLive Time to live (in minutes) setting of integration runtime which will execute copy activity.
 */
public data class CopyComputeScalePropertiesArgs(
    public val dataIntegrationUnit: Output<Int>? = null,
    public val timeToLive: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CopyComputeScalePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CopyComputeScalePropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.CopyComputeScalePropertiesArgs.builder()
            .dataIntegrationUnit(dataIntegrationUnit?.applyValue({ args0 -> args0 }))
            .timeToLive(timeToLive?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopyComputeScalePropertiesArgs].
 */
@PulumiTagMarker
public class CopyComputeScalePropertiesArgsBuilder internal constructor() {
    private var dataIntegrationUnit: Output<Int>? = null

    private var timeToLive: Output<Int>? = null

    /**
     * @param value DIU number setting reserved for copy activity execution. Supported values are multiples of 4 in range 4-256.
     */
    @JvmName("fvprornanrcrkcrv")
    public suspend fun dataIntegrationUnit(`value`: Output<Int>) {
        this.dataIntegrationUnit = value
    }

    /**
     * @param value Time to live (in minutes) setting of integration runtime which will execute copy activity.
     */
    @JvmName("xwbvublfgxwbqmtf")
    public suspend fun timeToLive(`value`: Output<Int>) {
        this.timeToLive = value
    }

    /**
     * @param value DIU number setting reserved for copy activity execution. Supported values are multiples of 4 in range 4-256.
     */
    @JvmName("ftmliqxfxfbvtwnp")
    public suspend fun dataIntegrationUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataIntegrationUnit = mapped
    }

    /**
     * @param value Time to live (in minutes) setting of integration runtime which will execute copy activity.
     */
    @JvmName("qtsnswevmmiqjcvl")
    public suspend fun timeToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    internal fun build(): CopyComputeScalePropertiesArgs = CopyComputeScalePropertiesArgs(
        dataIntegrationUnit = dataIntegrationUnit,
        timeToLive = timeToLive,
    )
}
