@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CosmosDbMongoDbApiLinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for CosmosDB (MongoDB API) data source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property database The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property isServerVersionAbove32 Whether the CosmosDB (MongoDB API) server version is higher than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'CosmosDbMongoDbApi'.
 */
public data class CosmosDbMongoDbApiLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>,
    public val database: Output<Any>,
    public val description: Output<String>? = null,
    public val isServerVersionAbove32: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CosmosDbMongoDbApiLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CosmosDbMongoDbApiLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.CosmosDbMongoDbApiLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .database(database.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isServerVersionAbove32(isServerVersionAbove32?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CosmosDbMongoDbApiLinkedServiceArgs].
 */
@PulumiTagMarker
public class CosmosDbMongoDbApiLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var isServerVersionAbove32: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("roippmjmwmkvsvdq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("nqdkvqwubapnwjwh")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hbqiicvcnnvdmvhp")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("isieytdykescwatu")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("bhujrjhfmyftrbuj")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType string).
     */
    @JvmName("mxbumdgevaxkkrlu")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rmafmrbjerimhllp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the CosmosDB (MongoDB API) server version is higher than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fvjoptkdhdfkmtxl")
    public suspend fun isServerVersionAbove32(`value`: Output<Any>) {
        this.isServerVersionAbove32 = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("mimugqghlusmiuqp")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'CosmosDbMongoDbApi'.
     */
    @JvmName("eokocgkugrmvsqid")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mtgcgqimgdmpixrs")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("goyhdpfeirteywct")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xyfgpllqidvhfwnq")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("lyujgdwgvxqjrwso")
    public suspend fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("xfxixyrqhvuwtcau")
    public suspend fun connectionString(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType string).
     */
    @JvmName("pclppbbmjulbhgjk")
    public suspend fun database(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("pfwfoycrytfcpylf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the CosmosDB (MongoDB API) server version is higher than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("mmommnslwvyxwxbq")
    public suspend fun isServerVersionAbove32(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isServerVersionAbove32 = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("scykrousslabibiu")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("qltgcavpkjgmhsgo")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("lhlyryceebsnshrr")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'CosmosDbMongoDbApi'.
     */
    @JvmName("ovlibkewonyhmeug")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CosmosDbMongoDbApiLinkedServiceArgs = CosmosDbMongoDbApiLinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
        database = database ?: throw PulumiNullFieldException("database"),
        description = description,
        isServerVersionAbove32 = isServerVersionAbove32,
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
