@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DWCopyCommandSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * DW Copy Command settings.
 * @property additionalOptions Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }
 * @property defaultValues Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
 */
public data class DWCopyCommandSettingsArgs(
    public val additionalOptions: Output<Map<String, String>>? = null,
    public val defaultValues: Output<List<DWCopyCommandDefaultValueArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DWCopyCommandSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DWCopyCommandSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.DWCopyCommandSettingsArgs.builder()
            .additionalOptions(
                additionalOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .defaultValues(
                defaultValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DWCopyCommandSettingsArgs].
 */
@PulumiTagMarker
public class DWCopyCommandSettingsArgsBuilder internal constructor() {
    private var additionalOptions: Output<Map<String, String>>? = null

    private var defaultValues: Output<List<DWCopyCommandDefaultValueArgs>>? = null

    /**
     * @param value Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }
     */
    @JvmName("ipteljjimlanojes")
    public suspend fun additionalOptions(`value`: Output<Map<String, String>>) {
        this.additionalOptions = value
    }

    /**
     * @param value Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("efiwqdmysnunwydh")
    public suspend fun defaultValues(`value`: Output<List<DWCopyCommandDefaultValueArgs>>) {
        this.defaultValues = value
    }

    @JvmName("efyhmdpyhknxdvsr")
    public suspend fun defaultValues(vararg values: Output<DWCopyCommandDefaultValueArgs>) {
        this.defaultValues = Output.all(values.asList())
    }

    /**
     * @param values Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("mdywcoeqoiodtoeg")
    public suspend fun defaultValues(values: List<Output<DWCopyCommandDefaultValueArgs>>) {
        this.defaultValues = Output.all(values)
    }

    /**
     * @param value Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }
     */
    @JvmName("bosdyqlwjubnsuhx")
    public suspend fun additionalOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalOptions = mapped
    }

    /**
     * @param values Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }
     */
    @JvmName("afwonjdgvlgaamgk")
    public fun additionalOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalOptions = mapped
    }

    /**
     * @param value Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("aluugcnywcaebqtj")
    public suspend fun defaultValues(`value`: List<DWCopyCommandDefaultValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValues = mapped
    }

    /**
     * @param argument Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("lplqsxrfluxauhrg")
    public suspend fun defaultValues(argument: List<suspend DWCopyCommandDefaultValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DWCopyCommandDefaultValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultValues = mapped
    }

    /**
     * @param argument Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("mbnxvtbkdjpmoipl")
    public suspend fun defaultValues(vararg argument: suspend DWCopyCommandDefaultValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DWCopyCommandDefaultValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultValues = mapped
    }

    /**
     * @param argument Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("cmkpgkwtisbargse")
    public suspend fun defaultValues(argument: suspend DWCopyCommandDefaultValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DWCopyCommandDefaultValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.defaultValues = mapped
    }

    /**
     * @param values Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("qynrejxeoegqugci")
    public suspend fun defaultValues(vararg values: DWCopyCommandDefaultValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultValues = mapped
    }

    internal fun build(): DWCopyCommandSettingsArgs = DWCopyCommandSettingsArgs(
        additionalOptions = additionalOptions,
        defaultValues = defaultValues,
    )
}
