@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DataFlowSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Transformation for data flow sink.
 * @property dataset Dataset reference.
 * @property description Transformation description.
 * @property flowlet Flowlet Reference
 * @property linkedService Linked service reference.
 * @property name Transformation name.
 * @property rejectedDataLinkedService Rejected data linked service reference.
 * @property schemaLinkedService Schema linked service reference.
 */
public data class DataFlowSinkArgs(
    public val dataset: Output<DatasetReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val flowlet: Output<DataFlowReferenceArgs>? = null,
    public val linkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val rejectedDataLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val schemaLinkedService: Output<LinkedServiceReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DataFlowSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DataFlowSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.DataFlowSinkArgs.builder()
            .dataset(dataset?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowlet(flowlet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedService(linkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .rejectedDataLinkedService(
                rejectedDataLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schemaLinkedService(
                schemaLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataFlowSinkArgs].
 */
@PulumiTagMarker
public class DataFlowSinkArgsBuilder internal constructor() {
    private var dataset: Output<DatasetReferenceArgs>? = null

    private var description: Output<String>? = null

    private var flowlet: Output<DataFlowReferenceArgs>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var rejectedDataLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var schemaLinkedService: Output<LinkedServiceReferenceArgs>? = null

    /**
     * @param value Dataset reference.
     */
    @JvmName("oyvqqugdqdhqilxt")
    public suspend fun dataset(`value`: Output<DatasetReferenceArgs>) {
        this.dataset = value
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("yghroawthfcadsuo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("gnypygrucmpvrrte")
    public suspend fun flowlet(`value`: Output<DataFlowReferenceArgs>) {
        this.flowlet = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("wndnejiocaftshwa")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("kvhvhtgtwdaebpxv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rejected data linked service reference.
     */
    @JvmName("dcqnteymghracjgk")
    public suspend fun rejectedDataLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.rejectedDataLinkedService = value
    }

    /**
     * @param value Schema linked service reference.
     */
    @JvmName("oxctewefejkcrvjy")
    public suspend fun schemaLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.schemaLinkedService = value
    }

    /**
     * @param value Dataset reference.
     */
    @JvmName("ntxswcxqhokjjkpo")
    public suspend fun dataset(`value`: DatasetReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param argument Dataset reference.
     */
    @JvmName("snjiicfdmclwhxsn")
    public suspend fun dataset(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataset = mapped
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("jybwjtdxmyxttnfn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("poddbsjkmgeafhcx")
    public suspend fun flowlet(`value`: DataFlowReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowlet = mapped
    }

    /**
     * @param argument Flowlet Reference
     */
    @JvmName("qwvaonvjnxhvwyag")
    public suspend fun flowlet(argument: suspend DataFlowReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.flowlet = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("eukmbnejfcihkxam")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("cthkwgioudiackuv")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("buscqjrwlbupxivr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rejected data linked service reference.
     */
    @JvmName("xxlvavqdvdxsusqg")
    public suspend fun rejectedDataLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedDataLinkedService = mapped
    }

    /**
     * @param argument Rejected data linked service reference.
     */
    @JvmName("vaoxvrueihdnhonu")
    public suspend fun rejectedDataLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rejectedDataLinkedService = mapped
    }

    /**
     * @param value Schema linked service reference.
     */
    @JvmName("tgsixxxdtqwhcchy")
    public suspend fun schemaLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaLinkedService = mapped
    }

    /**
     * @param argument Schema linked service reference.
     */
    @JvmName("vkurhtegcvgdarls")
    public suspend fun schemaLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schemaLinkedService = mapped
    }

    internal fun build(): DataFlowSinkArgs = DataFlowSinkArgs(
        dataset = dataset,
        description = description,
        flowlet = flowlet,
        linkedService = linkedService,
        name = name ?: throw PulumiNullFieldException("name"),
        rejectedDataLinkedService = rejectedDataLinkedService,
        schemaLinkedService = schemaLinkedService,
    )
}
