@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DatasetFolderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property name The name of the folder that this Dataset is in.
 */
public data class DatasetFolderArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DatasetFolderArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DatasetFolderArgs =
        com.pulumi.azurenative.datafactory.inputs.DatasetFolderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetFolderArgs].
 */
@PulumiTagMarker
public class DatasetFolderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the folder that this Dataset is in.
     */
    @JvmName("kqjxhpgfjpmouvwl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the folder that this Dataset is in.
     */
    @JvmName("posahdawjkxgkxqc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DatasetFolderArgs = DatasetFolderArgs(
        name = name,
    )
}
