@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DelimitedTextDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Delimited text dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property columnDelimiter The column delimiter. Type: string (or Expression with resultType string).
 * @property compressionCodec The data compressionCodec. Type: string (or Expression with resultType string).
 * @property compressionLevel The data compression method used for DelimitedText.
 * @property description Dataset description.
 * @property encodingName The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
 * @property escapeChar The escape character. Type: string (or Expression with resultType string).
 * @property firstRowAsHeader When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property location The location of the delimited text storage.
 * @property nullValue The null value string. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property quoteChar The quote character. Type: string (or Expression with resultType string).
 * @property rowDelimiter The row delimiter. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'DelimitedText'.
 */
public data class DelimitedTextDatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val columnDelimiter: Output<Any>? = null,
    public val compressionCodec: Output<Any>? = null,
    public val compressionLevel: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encodingName: Output<Any>? = null,
    public val escapeChar: Output<Any>? = null,
    public val firstRowAsHeader: Output<Any>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val location: Output<Any>,
    public val nullValue: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val quoteChar: Output<Any>? = null,
    public val rowDelimiter: Output<Any>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DelimitedTextDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DelimitedTextDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.DelimitedTextDatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .columnDelimiter(columnDelimiter?.applyValue({ args0 -> args0 }))
            .compressionCodec(compressionCodec?.applyValue({ args0 -> args0 }))
            .compressionLevel(compressionLevel?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encodingName(encodingName?.applyValue({ args0 -> args0 }))
            .escapeChar(escapeChar?.applyValue({ args0 -> args0 }))
            .firstRowAsHeader(firstRowAsHeader?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location.applyValue({ args0 -> args0 }))
            .nullValue(nullValue?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .quoteChar(quoteChar?.applyValue({ args0 -> args0 }))
            .rowDelimiter(rowDelimiter?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelimitedTextDatasetArgs].
 */
@PulumiTagMarker
public class DelimitedTextDatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var columnDelimiter: Output<Any>? = null

    private var compressionCodec: Output<Any>? = null

    private var compressionLevel: Output<Any>? = null

    private var description: Output<String>? = null

    private var encodingName: Output<Any>? = null

    private var escapeChar: Output<Any>? = null

    private var firstRowAsHeader: Output<Any>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var location: Output<Any>? = null

    private var nullValue: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var quoteChar: Output<Any>? = null

    private var rowDelimiter: Output<Any>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("nsdcrjjjdpvscrpq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("irdfxcajgvweroxp")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("locupilpxbrwfbpx")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The column delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("mbkpjvkxihokwsmc")
    public suspend fun columnDelimiter(`value`: Output<Any>) {
        this.columnDelimiter = value
    }

    /**
     * @param value The data compressionCodec. Type: string (or Expression with resultType string).
     */
    @JvmName("xkwqsgkaxpyktavl")
    public suspend fun compressionCodec(`value`: Output<Any>) {
        this.compressionCodec = value
    }

    /**
     * @param value The data compression method used for DelimitedText.
     */
    @JvmName("ogrstgqbnopyusvg")
    public suspend fun compressionLevel(`value`: Output<Any>) {
        this.compressionLevel = value
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("uoamvibddqmxaoop")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
     */
    @JvmName("skuffhfjwbvlhxjs")
    public suspend fun encodingName(`value`: Output<Any>) {
        this.encodingName = value
    }

    /**
     * @param value The escape character. Type: string (or Expression with resultType string).
     */
    @JvmName("ihcrqongpnsukpjf")
    public suspend fun escapeChar(`value`: Output<Any>) {
        this.escapeChar = value
    }

    /**
     * @param value When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vsvpjpwbeserasxs")
    public suspend fun firstRowAsHeader(`value`: Output<Any>) {
        this.firstRowAsHeader = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("davcjnvwujtvmuxa")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("duhieiysxgduydlb")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The location of the delimited text storage.
     */
    @JvmName("kywmoausrogqqdad")
    public suspend fun location(`value`: Output<Any>) {
        this.location = value
    }

    /**
     * @param value The null value string. Type: string (or Expression with resultType string).
     */
    @JvmName("ibdfermhqxacsdcw")
    public suspend fun nullValue(`value`: Output<Any>) {
        this.nullValue = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("rosrpwasvouhesbb")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The quote character. Type: string (or Expression with resultType string).
     */
    @JvmName("oaxyxoeamiajlbfb")
    public suspend fun quoteChar(`value`: Output<Any>) {
        this.quoteChar = value
    }

    /**
     * @param value The row delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("cpehgmqqnrfbpsek")
    public suspend fun rowDelimiter(`value`: Output<Any>) {
        this.rowDelimiter = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("dwapdbiybnagetht")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("aaebbvqoghtvwhul")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'DelimitedText'.
     */
    @JvmName("oilhgrbjqsrysanu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("pgvyjmvltgbmyqys")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("snwikstixcdqjwas")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The column delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("yjhftpvehxpskdby")
    public suspend fun columnDelimiter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnDelimiter = mapped
    }

    /**
     * @param value The data compressionCodec. Type: string (or Expression with resultType string).
     */
    @JvmName("ultygpjxtqqofxhy")
    public suspend fun compressionCodec(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionCodec = mapped
    }

    /**
     * @param value The data compression method used for DelimitedText.
     */
    @JvmName("mobyrgopckobjstc")
    public suspend fun compressionLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionLevel = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("wjrvbxkmxoromdjc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
     */
    @JvmName("dwuktsjthbsegion")
    public suspend fun encodingName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingName = mapped
    }

    /**
     * @param value The escape character. Type: string (or Expression with resultType string).
     */
    @JvmName("xcmikfatptvyekrk")
    public suspend fun escapeChar(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escapeChar = mapped
    }

    /**
     * @param value When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gxlhsyhtoqipfapx")
    public suspend fun firstRowAsHeader(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstRowAsHeader = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("lyymgfehgengrwjp")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("kkiksfdbjgpkferb")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("alulermmseikbcsl")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("ftnxlawxnsmmpvyi")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The location of the delimited text storage.
     */
    @JvmName("iyevkvndcpfgsjcd")
    public suspend fun location(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The null value string. Type: string (or Expression with resultType string).
     */
    @JvmName("fqqinspsvpousdnx")
    public suspend fun nullValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nullValue = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("wbxxtcxutvoskksy")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("sbsubydfgpeqkdhd")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("mlwmussxndyfeuov")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The quote character. Type: string (or Expression with resultType string).
     */
    @JvmName("qnaehoocrwklbyxb")
    public suspend fun quoteChar(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteChar = mapped
    }

    /**
     * @param value The row delimiter. Type: string (or Expression with resultType string).
     */
    @JvmName("pkjfnjygujldibqu")
    public suspend fun rowDelimiter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowDelimiter = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("upbwbgxxuncttqsx")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("idxiyluiltyiddgh")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'DelimitedText'.
     */
    @JvmName("rcawisynqxcsbmgv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DelimitedTextDatasetArgs = DelimitedTextDatasetArgs(
        annotations = annotations,
        columnDelimiter = columnDelimiter,
        compressionCodec = compressionCodec,
        compressionLevel = compressionLevel,
        description = description,
        encodingName = encodingName,
        escapeChar = escapeChar,
        firstRowAsHeader = firstRowAsHeader,
        folder = folder,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        location = location ?: throw PulumiNullFieldException("location"),
        nullValue = nullValue,
        parameters = parameters,
        quoteChar = quoteChar,
        rowDelimiter = rowDelimiter,
        schema = schema,
        structure = structure,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
