@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DelimitedTextWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Delimited text write settings.
 * @property fileExtension The file extension used to create the files. Type: string (or Expression with resultType string).
 * @property fileNamePrefix Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
 * @property maxRowsPerFile Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
 * @property quoteAllText Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
 * @property type The write setting type.
 * Expected value is 'DelimitedTextWriteSettings'.
 */
public data class DelimitedTextWriteSettingsArgs(
    public val fileExtension: Output<Any>,
    public val fileNamePrefix: Output<Any>? = null,
    public val maxRowsPerFile: Output<Any>? = null,
    public val quoteAllText: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DelimitedTextWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DelimitedTextWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.DelimitedTextWriteSettingsArgs.builder()
            .fileExtension(fileExtension.applyValue({ args0 -> args0 }))
            .fileNamePrefix(fileNamePrefix?.applyValue({ args0 -> args0 }))
            .maxRowsPerFile(maxRowsPerFile?.applyValue({ args0 -> args0 }))
            .quoteAllText(quoteAllText?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelimitedTextWriteSettingsArgs].
 */
@PulumiTagMarker
public class DelimitedTextWriteSettingsArgsBuilder internal constructor() {
    private var fileExtension: Output<Any>? = null

    private var fileNamePrefix: Output<Any>? = null

    private var maxRowsPerFile: Output<Any>? = null

    private var quoteAllText: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The file extension used to create the files. Type: string (or Expression with resultType string).
     */
    @JvmName("lpxlkrxaycjhmjbv")
    public suspend fun fileExtension(`value`: Output<Any>) {
        this.fileExtension = value
    }

    /**
     * @param value Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JvmName("uamuelfpvvnixwrg")
    public suspend fun fileNamePrefix(`value`: Output<Any>) {
        this.fileNamePrefix = value
    }

    /**
     * @param value Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bvkwcpbatnuratvy")
    public suspend fun maxRowsPerFile(`value`: Output<Any>) {
        this.maxRowsPerFile = value
    }

    /**
     * @param value Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("hdqvknhweamxljpt")
    public suspend fun quoteAllText(`value`: Output<Any>) {
        this.quoteAllText = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'DelimitedTextWriteSettings'.
     */
    @JvmName("soguceutxawigxsd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The file extension used to create the files. Type: string (or Expression with resultType string).
     */
    @JvmName("rpimemaganxfnyeq")
    public suspend fun fileExtension(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileExtension = mapped
    }

    /**
     * @param value Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JvmName("sxdgcungsaivcswd")
    public suspend fun fileNamePrefix(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileNamePrefix = mapped
    }

    /**
     * @param value Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rxwmolnpqkdxrxcb")
    public suspend fun maxRowsPerFile(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRowsPerFile = mapped
    }

    /**
     * @param value Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nnohhkmkvtrfcsyv")
    public suspend fun quoteAllText(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteAllText = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'DelimitedTextWriteSettings'.
     */
    @JvmName("phfolcshfykxgijt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DelimitedTextWriteSettingsArgs = DelimitedTextWriteSettingsArgs(
        fileExtension = fileExtension ?: throw PulumiNullFieldException("fileExtension"),
        fileNamePrefix = fileNamePrefix,
        maxRowsPerFile = maxRowsPerFile,
        quoteAllText = quoteAllText,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
