@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.EncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of CMK for the factory.
 * @property identity User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be used.
 * @property keyName The name of the key in Azure Key Vault to use as Customer Managed Key.
 * @property keyVersion The version of the key used for CMK. If not provided, latest version will be used.
 * @property vaultBaseUrl The url of the Azure Key Vault used for CMK.
 */
public data class EncryptionConfigurationArgs(
    public val identity: Output<CMKIdentityDefinitionArgs>? = null,
    public val keyName: Output<String>,
    public val keyVersion: Output<String>? = null,
    public val vaultBaseUrl: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.EncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.EncryptionConfigurationArgs =
        com.pulumi.azurenative.datafactory.inputs.EncryptionConfigurationArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 }))
            .vaultBaseUrl(vaultBaseUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class EncryptionConfigurationArgsBuilder internal constructor() {
    private var identity: Output<CMKIdentityDefinitionArgs>? = null

    private var keyName: Output<String>? = null

    private var keyVersion: Output<String>? = null

    private var vaultBaseUrl: Output<String>? = null

    /**
     * @param value User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be used.
     */
    @JvmName("lmkdytdapjbnjmak")
    public suspend fun identity(`value`: Output<CMKIdentityDefinitionArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the key in Azure Key Vault to use as Customer Managed Key.
     */
    @JvmName("tbskoyagiqycvhrb")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The version of the key used for CMK. If not provided, latest version will be used.
     */
    @JvmName("ksgfncjpttysnjol")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The url of the Azure Key Vault used for CMK.
     */
    @JvmName("bqfevvhwrovpkgqd")
    public suspend fun vaultBaseUrl(`value`: Output<String>) {
        this.vaultBaseUrl = value
    }

    /**
     * @param value User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be used.
     */
    @JvmName("opiaodecxwxrdwfi")
    public suspend fun identity(`value`: CMKIdentityDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be used.
     */
    @JvmName("fcyenxkijfmsgbqr")
    public suspend fun identity(argument: suspend CMKIdentityDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = CMKIdentityDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the key in Azure Key Vault to use as Customer Managed Key.
     */
    @JvmName("xnqeqcsdijsihvdb")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The version of the key used for CMK. If not provided, latest version will be used.
     */
    @JvmName("iqmbyairirmhybqy")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    /**
     * @param value The url of the Azure Key Vault used for CMK.
     */
    @JvmName("usrmecbekvcwycdj")
    public suspend fun vaultBaseUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultBaseUrl = mapped
    }

    internal fun build(): EncryptionConfigurationArgs = EncryptionConfigurationArgs(
        identity = identity,
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVersion = keyVersion,
        vaultBaseUrl = vaultBaseUrl ?: throw PulumiNullFieldException("vaultBaseUrl"),
    )
}
