@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExpressionV2Args.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ExpressionV2Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Nested representation of a complex expression.
 * @property operands List of nested expressions.
 * @property operators Expression operator value Type: list of strings.
 * @property type Type of expressions supported by the system. Type: string.
 * @property value Value for Constant/Field Type: string.
 */
public data class ExpressionV2Args(
    public val operands: Output<List<ExpressionV2Args>>? = null,
    public val operators: Output<List<String>>? = null,
    public val type: Output<Either<String, ExpressionV2Type>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExpressionV2Args> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ExpressionV2Args =
        com.pulumi.azurenative.datafactory.inputs.ExpressionV2Args.builder()
            .operands(
                operands?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .operators(operators?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressionV2Args].
 */
@PulumiTagMarker
public class ExpressionV2ArgsBuilder internal constructor() {
    private var operands: Output<List<ExpressionV2Args>>? = null

    private var operators: Output<List<String>>? = null

    private var type: Output<Either<String, ExpressionV2Type>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value List of nested expressions.
     */
    @JvmName("uyncknuqcxsnuftd")
    public suspend fun operands(`value`: Output<List<ExpressionV2Args>>) {
        this.operands = value
    }

    @JvmName("ojgkmcovqigtiruh")
    public suspend fun operands(vararg values: Output<ExpressionV2Args>) {
        this.operands = Output.all(values.asList())
    }

    /**
     * @param values List of nested expressions.
     */
    @JvmName("rbkvbpcrevsujcfn")
    public suspend fun operands(values: List<Output<ExpressionV2Args>>) {
        this.operands = Output.all(values)
    }

    /**
     * @param value Expression operator value Type: list of strings.
     */
    @JvmName("qwrjmvsvbtamjins")
    public suspend fun operators(`value`: Output<List<String>>) {
        this.operators = value
    }

    @JvmName("bqfjgtrunrglmtcg")
    public suspend fun operators(vararg values: Output<String>) {
        this.operators = Output.all(values.asList())
    }

    /**
     * @param values Expression operator value Type: list of strings.
     */
    @JvmName("ipqhqmiffogvusib")
    public suspend fun operators(values: List<Output<String>>) {
        this.operators = Output.all(values)
    }

    /**
     * @param value Type of expressions supported by the system. Type: string.
     */
    @JvmName("fowvqbfatxdocmtj")
    public suspend fun type(`value`: Output<Either<String, ExpressionV2Type>>) {
        this.type = value
    }

    /**
     * @param value Value for Constant/Field Type: string.
     */
    @JvmName("wceqhjljotulparl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value List of nested expressions.
     */
    @JvmName("ivfoqqimlvavaxfu")
    public suspend fun operands(`value`: List<ExpressionV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operands = mapped
    }

    /**
     * @param argument List of nested expressions.
     */
    @JvmName("xwtfmhguljwhvqqk")
    public suspend fun operands(argument: List<suspend ExpressionV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressionV2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.operands = mapped
    }

    /**
     * @param argument List of nested expressions.
     */
    @JvmName("rkbjccinrmekqgdb")
    public suspend fun operands(vararg argument: suspend ExpressionV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExpressionV2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.operands = mapped
    }

    /**
     * @param argument List of nested expressions.
     */
    @JvmName("kvhhosiutlxcpfru")
    public suspend fun operands(argument: suspend ExpressionV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExpressionV2ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.operands = mapped
    }

    /**
     * @param values List of nested expressions.
     */
    @JvmName("nllnbjguiqoelajf")
    public suspend fun operands(vararg values: ExpressionV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operands = mapped
    }

    /**
     * @param value Expression operator value Type: list of strings.
     */
    @JvmName("cbgcpsexharqhwvx")
    public suspend fun operators(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operators = mapped
    }

    /**
     * @param values Expression operator value Type: list of strings.
     */
    @JvmName("twhxadujuhbgmxml")
    public suspend fun operators(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operators = mapped
    }

    /**
     * @param value Type of expressions supported by the system. Type: string.
     */
    @JvmName("bhdsmsdomjrvixlq")
    public suspend fun type(`value`: Either<String, ExpressionV2Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of expressions supported by the system. Type: string.
     */
    @JvmName("orcdsncaqklxrywm")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressionV2Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of expressions supported by the system. Type: string.
     */
    @JvmName("gsehryfywlyqunwv")
    public fun type(`value`: ExpressionV2Type) {
        val toBeMapped = Either.ofRight<String, ExpressionV2Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value for Constant/Field Type: string.
     */
    @JvmName("fdauomhvlskogfav")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ExpressionV2Args = ExpressionV2Args(
        operands = operands,
        operators = operators,
        type = type,
        `value` = `value`,
    )
}
