@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.FileShareDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An on-premises file system dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property compression The data compression method used for the file system.
 * @property description Dataset description.
 * @property fileFilter Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
 * @property fileName The name of the on-premises file system. Type: string (or Expression with resultType string).
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property folderPath The path of the on-premises file system. Type: string (or Expression with resultType string).
 * @property format The format of the files.
 * @property linkedServiceName Linked service reference.
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'FileShare'.
 */
public data class FileShareDatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val compression: Output<DatasetCompressionArgs>? = null,
    public val description: Output<String>? = null,
    public val fileFilter: Output<Any>? = null,
    public val fileName: Output<Any>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val folderPath: Output<Any>? = null,
    public val format: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.FileShareDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.FileShareDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.FileShareDatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .compression(compression?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fileFilter(fileFilter?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileShareDatasetArgs].
 */
@PulumiTagMarker
public class FileShareDatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var compression: Output<DatasetCompressionArgs>? = null

    private var description: Output<String>? = null

    private var fileFilter: Output<Any>? = null

    private var fileName: Output<Any>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var folderPath: Output<Any>? = null

    private var format: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("cmqedctwdecagxwy")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ggrornemghsqjyrn")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("ohbmtaashbwtvnel")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The data compression method used for the file system.
     */
    @JvmName("pebavtcdhmjfiokd")
    public suspend fun compression(`value`: Output<DatasetCompressionArgs>) {
        this.compression = value
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("eiumnqbonxknnpns")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
     */
    @JvmName("iryqxquybadqbhdp")
    public suspend fun fileFilter(`value`: Output<Any>) {
        this.fileFilter = value
    }

    /**
     * @param value The name of the on-premises file system. Type: string (or Expression with resultType string).
     */
    @JvmName("bvjokmisltsfpfba")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("hrlylqbmnanurvyl")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value The path of the on-premises file system. Type: string (or Expression with resultType string).
     */
    @JvmName("ssgdsfltvoqokjuc")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value The format of the files.
     */
    @JvmName("xoobskoefyrkcjgu")
    public suspend fun format(`value`: Output<Any>) {
        this.format = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("cypwdeuohewypvfl")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("wchbfivrgpnvuhtv")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("ovmlcdwkbeyrwsws")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("cfrdbhyuntkqiifd")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("uwtrvthwnsgbspcf")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("qpprinkjronpjjao")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'FileShare'.
     */
    @JvmName("lnlvfpvtvrqeejfs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("lagqrkkslkotwypm")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("iseurvvyjymmxavt")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The data compression method used for the file system.
     */
    @JvmName("yjhnykkpiulxikdl")
    public suspend fun compression(`value`: DatasetCompressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param argument The data compression method used for the file system.
     */
    @JvmName("uibbmudhivgmvfbl")
    public suspend fun compression(argument: suspend DatasetCompressionArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCompressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compression = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("nowpiuqwmidwcqgr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
     */
    @JvmName("bnpbxllsqdyfioto")
    public suspend fun fileFilter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFilter = mapped
    }

    /**
     * @param value The name of the on-premises file system. Type: string (or Expression with resultType string).
     */
    @JvmName("xsjyivwcyiujbqit")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("qnvgdtsqfclrgpoe")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("lhwaewbqxeknxfyu")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value The path of the on-premises file system. Type: string (or Expression with resultType string).
     */
    @JvmName("fkdxpgbgdoviysbb")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value The format of the files.
     */
    @JvmName("grnvjclqdwutyukn")
    public suspend fun format(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("gibtviceivvfocws")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("lmnsvacqyedynwvr")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("avmiscaqltsdcqja")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("pyghlbeafufscqgs")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("seljlcnvfrrrffak")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("diwamfrwmkhkqjjp")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("sklgdhowgxnlihik")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("tfwbhuidpuskcdag")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("srhjiqespeijyhiw")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'FileShare'.
     */
    @JvmName("qlnmchghfyloakvn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FileShareDatasetArgs = FileShareDatasetArgs(
        annotations = annotations,
        compression = compression,
        description = description,
        fileFilter = fileFilter,
        fileName = fileName,
        folder = folder,
        folderPath = folderPath,
        format = format,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        parameters = parameters,
        schema = schema,
        structure = structure,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
