@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetFactoryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property resourceGroupName The resource group name.
 */
public data class GetFactoryPlainArgs(
    public val factoryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetFactoryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetFactoryPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetFactoryPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFactoryPlainArgs].
 */
@PulumiTagMarker
public class GetFactoryPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("uuvvflhsubwyaxvp")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nxewxcincprmqysp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFactoryPlainArgs = GetFactoryPlainArgs(
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
