@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property integrationRuntimeName The integration runtime name.
 * @property metadataPath Metadata path.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationRuntimeObjectMetadatumPlainArgs(
    public val factoryName: String,
    public val integrationRuntimeName: String,
    public val metadataPath: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .integrationRuntimeName(integrationRuntimeName.let({ args0 -> args0 }))
            .metadataPath(metadataPath?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationRuntimeObjectMetadatumPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var integrationRuntimeName: String? = null

    private var metadataPath: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("nnkfhbhuqquxocvf")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The integration runtime name.
     */
    @JvmName("hodjdarvvvhriccp")
    public suspend fun integrationRuntimeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationRuntimeName = mapped
    }

    /**
     * @param value Metadata path.
     */
    @JvmName("esfyjjjorpkqehlf")
    public suspend fun metadataPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metadataPath = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ukaaydxanqhbjhxi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationRuntimeObjectMetadatumPlainArgs =
        GetIntegrationRuntimeObjectMetadatumPlainArgs(
            factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
            integrationRuntimeName = integrationRuntimeName ?: throw
                PulumiNullFieldException("integrationRuntimeName"),
            metadataPath = metadataPath,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
