@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightHiveActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.HDInsightActivityDebugInfoOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight Hive activity type.
 * @property arguments User specified arguments to HDInsightActivity.
 * @property defines Allows user to specify defines for Hive job request.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property getDebugInfo Debug info option.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property queryTimeout Query timeout value (in minutes).  Effective when the HDInsight cluster is with ESP (Enterprise Security Package)
 * @property scriptLinkedService Script linked service reference.
 * @property scriptPath Script path. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storageLinkedServices Storage linked service references.
 * @property type Type of activity.
 * Expected value is 'HDInsightHive'.
 * @property userProperties Activity user properties.
 * @property variables User specified arguments under hivevar namespace.
 */
public data class HDInsightHiveActivityArgs(
    public val arguments: Output<List<Any>>? = null,
    public val defines: Output<Map<String, Any>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val queryTimeout: Output<Int>? = null,
    public val scriptLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val scriptPath: Output<Any>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
    public val variables: Output<Map<String, Any>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightHiveActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HDInsightHiveActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightHiveActivityArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defines(defines?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .getDebugInfo(
                getDebugInfo?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .scriptLinkedService(
                scriptLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scriptPath(scriptPath?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageLinkedServices(
                storageLinkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HDInsightHiveActivityArgs].
 */
@PulumiTagMarker
public class HDInsightHiveActivityArgsBuilder internal constructor() {
    private var arguments: Output<List<Any>>? = null

    private var defines: Output<Map<String, Any>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var queryTimeout: Output<Int>? = null

    private var scriptLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var scriptPath: Output<Any>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    private var variables: Output<Map<String, Any>>? = null

    /**
     * @param value User specified arguments to HDInsightActivity.
     */
    @JvmName("dubkuqvnmtncyihv")
    public suspend fun arguments(`value`: Output<List<Any>>) {
        this.arguments = value
    }

    @JvmName("oayfcbixcvhmhrxb")
    public suspend fun arguments(vararg values: Output<Any>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values User specified arguments to HDInsightActivity.
     */
    @JvmName("lubiakydkkwhlcxg")
    public suspend fun arguments(values: List<Output<Any>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value Allows user to specify defines for Hive job request.
     */
    @JvmName("fpfcpdeaemtlwqrq")
    public suspend fun defines(`value`: Output<Map<String, Any>>) {
        this.defines = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("hbcqvirtmjvswtjh")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("urmfawyuohnpoqad")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("hhkhglthggugyuhi")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("tynxrywdbaicwvrd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("tvijkisuhbtihdyr")
    public suspend fun getDebugInfo(`value`: Output<Either<String, HDInsightActivityDebugInfoOption>>) {
        this.getDebugInfo = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("wnnchmeayaipthau")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("jufxhhoensgtabmm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("wuwtukvwdmqmuwyx")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("bktsgmocpeehhcyi")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Query timeout value (in minutes).  Effective when the HDInsight cluster is with ESP (Enterprise Security Package)
     */
    @JvmName("ytlejxehmptgwojs")
    public suspend fun queryTimeout(`value`: Output<Int>) {
        this.queryTimeout = value
    }

    /**
     * @param value Script linked service reference.
     */
    @JvmName("kkebeilnqkrbtalp")
    public suspend fun scriptLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.scriptLinkedService = value
    }

    /**
     * @param value Script path. Type: string (or Expression with resultType string).
     */
    @JvmName("nfcwemtoncnlbfnc")
    public suspend fun scriptPath(`value`: Output<Any>) {
        this.scriptPath = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("fsdhhiedvelolxuq")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("nrqeagwsgilbttes")
    public suspend fun storageLinkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = value
    }

    @JvmName("icdtwtmyfhwtpwqf")
    public suspend fun storageLinkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.storageLinkedServices = Output.all(values.asList())
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("tvdosewldwqhaeta")
    public suspend fun storageLinkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = Output.all(values)
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightHive'.
     */
    @JvmName("nddvqtdwpwkkiapo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("cjdaohcgbcnwslon")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("kjkadpeeijfxtrud")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("llqcrpuxxwebtjbu")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value User specified arguments under hivevar namespace.
     */
    @JvmName("prhtsxxdiobdmoly")
    public suspend fun variables(`value`: Output<Map<String, Any>>) {
        this.variables = value
    }

    /**
     * @param value User specified arguments to HDInsightActivity.
     */
    @JvmName("ckeropajbrciehaq")
    public suspend fun arguments(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values User specified arguments to HDInsightActivity.
     */
    @JvmName("kvhooypnkvhcdase")
    public suspend fun arguments(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Allows user to specify defines for Hive job request.
     */
    @JvmName("fanrguciwsivpxxi")
    public suspend fun defines(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param values Allows user to specify defines for Hive job request.
     */
    @JvmName("anjydlqaudetkayy")
    public fun defines(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("xfbfimbkxuubgtnb")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("vbyirqfkskllekrg")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("aielhtwvoieclguy")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("irnttryqspqiylvi")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("fmgcrgfixlvusyer")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("ctygdfyrmttesivv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("pulerjujjosexqiu")
    public suspend fun getDebugInfo(`value`: Either<String, HDInsightActivityDebugInfoOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("acshpfebjrdufoge")
    public fun getDebugInfo(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("eohhtelgqoslblbr")
    public fun getDebugInfo(`value`: HDInsightActivityDebugInfoOption) {
        val toBeMapped = Either.ofRight<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("rtgbcmsnaxbvrksa")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("njbsqdemrjwdcigv")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("hbtgvmniuqpgeujm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("dtloqwrcdhapeaks")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("nmetrdoufkbkkybw")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("jiuwjwhfidnprnau")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("uudkarscpigwepfj")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("itxfbmwflqqqcogr")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Query timeout value (in minutes).  Effective when the HDInsight cluster is with ESP (Enterprise Security Package)
     */
    @JvmName("wxiceuvgbglqsplc")
    public suspend fun queryTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value Script linked service reference.
     */
    @JvmName("ljpfdsnkastgotaf")
    public suspend fun scriptLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptLinkedService = mapped
    }

    /**
     * @param argument Script linked service reference.
     */
    @JvmName("fichtimwgtpcrrlk")
    public suspend fun scriptLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scriptLinkedService = mapped
    }

    /**
     * @param value Script path. Type: string (or Expression with resultType string).
     */
    @JvmName("ysxfbguupksjcang")
    public suspend fun scriptPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptPath = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("wmnsvdonicmalxcw")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ijpjwshcxdoblsmm")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ggrogtfvvwcruxqw")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("olldnhtadbfnlcyf")
    public suspend fun storageLinkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("kaocklsybhggurmy")
    public suspend fun storageLinkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("iynnvljattwukqkn")
    public suspend fun storageLinkedServices(vararg argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("dwkxbdymhaceweup")
    public suspend fun storageLinkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("pxlsqwqagkatkxgd")
    public suspend fun storageLinkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightHive'.
     */
    @JvmName("hpjedscevajwvjrf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("nvlyfnitiwlxbxlu")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("eqbmefetvofsxrhx")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("pitxywdnwymwxifh")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("bujroddbvhkkrxnd")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("ftcqgqchopodknhx")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param value User specified arguments under hivevar namespace.
     */
    @JvmName("njxtwinjriftbkye")
    public suspend fun variables(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param values User specified arguments under hivevar namespace.
     */
    @JvmName("lmkxphibxflqljfy")
    public fun variables(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    internal fun build(): HDInsightHiveActivityArgs = HDInsightHiveActivityArgs(
        arguments = arguments,
        defines = defines,
        dependsOn = dependsOn,
        description = description,
        getDebugInfo = getDebugInfo,
        linkedServiceName = linkedServiceName,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        queryTimeout = queryTimeout,
        scriptLinkedService = scriptLinkedService,
        scriptPath = scriptPath,
        state = state,
        storageLinkedServices = storageLinkedServices,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
        variables = variables,
    )
}
