@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HDInsightPigActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.HDInsightActivityDebugInfoOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HDInsight Pig activity type.
 * @property arguments User specified arguments to HDInsightActivity. Type: array (or Expression with resultType array).
 * @property defines Allows user to specify defines for Pig job request.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property getDebugInfo Debug info option.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property scriptLinkedService Script linked service reference.
 * @property scriptPath Script path. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storageLinkedServices Storage linked service references.
 * @property type Type of activity.
 * Expected value is 'HDInsightPig'.
 * @property userProperties Activity user properties.
 */
public data class HDInsightPigActivityArgs(
    public val arguments: Output<Any>? = null,
    public val defines: Output<Map<String, Any>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val scriptLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val scriptPath: Output<Any>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HDInsightPigActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HDInsightPigActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.HDInsightPigActivityArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0 }))
            .defines(defines?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .getDebugInfo(
                getDebugInfo?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scriptLinkedService(
                scriptLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scriptPath(scriptPath?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageLinkedServices(
                storageLinkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HDInsightPigActivityArgs].
 */
@PulumiTagMarker
public class HDInsightPigActivityArgsBuilder internal constructor() {
    private var arguments: Output<Any>? = null

    private var defines: Output<Map<String, Any>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var getDebugInfo: Output<Either<String, HDInsightActivityDebugInfoOption>>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var scriptLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var scriptPath: Output<Any>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var storageLinkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value User specified arguments to HDInsightActivity. Type: array (or Expression with resultType array).
     */
    @JvmName("pfwikukxrryofsws")
    public suspend fun arguments(`value`: Output<Any>) {
        this.arguments = value
    }

    /**
     * @param value Allows user to specify defines for Pig job request.
     */
    @JvmName("ucnqthasvfwoevvr")
    public suspend fun defines(`value`: Output<Map<String, Any>>) {
        this.defines = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("wpcqsbyqdygtxmbq")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("osdyjgdpggooluus")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("pycnruebtkcinuat")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("hevypcxhrkexxtis")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("saxmqkjkeyhafppc")
    public suspend fun getDebugInfo(`value`: Output<Either<String, HDInsightActivityDebugInfoOption>>) {
        this.getDebugInfo = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("vpegbiqdhenescgr")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("uaqkicyvbgsxxbhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("eagaeksbasfweewx")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("lycrrbrxuvfeemkf")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Script linked service reference.
     */
    @JvmName("aaawhdndfxdfcmgd")
    public suspend fun scriptLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.scriptLinkedService = value
    }

    /**
     * @param value Script path. Type: string (or Expression with resultType string).
     */
    @JvmName("xhkuhgbbsdjuuxst")
    public suspend fun scriptPath(`value`: Output<Any>) {
        this.scriptPath = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("polqfwtkxejrsdum")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("cudgibiuqnndxbfe")
    public suspend fun storageLinkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = value
    }

    @JvmName("pjtvkbldwhnfujdx")
    public suspend fun storageLinkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.storageLinkedServices = Output.all(values.asList())
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("hbopngbshxsbgvly")
    public suspend fun storageLinkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.storageLinkedServices = Output.all(values)
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightPig'.
     */
    @JvmName("txmsubmxbcaqbjah")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("ymnboybclpkfdqgl")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("frbqrdadubywghvy")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("ryotxrciertttpyu")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value User specified arguments to HDInsightActivity. Type: array (or Expression with resultType array).
     */
    @JvmName("khlmamfwpgnvggny")
    public suspend fun arguments(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Allows user to specify defines for Pig job request.
     */
    @JvmName("guntujihrecwjeaa")
    public suspend fun defines(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param values Allows user to specify defines for Pig job request.
     */
    @JvmName("ptssdlcwpsmhpbaw")
    public fun defines(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defines = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("tmepmjyiahrlkjtl")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("rpagtjlwkxexodgx")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("seyofxegnsbbiepa")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("iexngtaloayipwbo")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("dhvsluphndvdlsul")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("gafhmrpaxiuywcxh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("jvghuqhqmvuiakym")
    public suspend fun getDebugInfo(`value`: Either<String, HDInsightActivityDebugInfoOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("eqrttxyargtnrykw")
    public fun getDebugInfo(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Debug info option.
     */
    @JvmName("ggjgqykgibhrtxgk")
    public fun getDebugInfo(`value`: HDInsightActivityDebugInfoOption) {
        val toBeMapped = Either.ofRight<String, HDInsightActivityDebugInfoOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.getDebugInfo = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("llekwoowerjhxttb")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("abwtmonmoqgkhtav")
    public suspend fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("vvllbwkixssvjhtb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("brxljpbokkxbqgya")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("srbrypesvwhpmnqs")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("gsxvhwskehvysfge")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("sofuyitepnyomajc")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("xnhjjwqpphdctvup")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Script linked service reference.
     */
    @JvmName("kmjyievtdwqbgluf")
    public suspend fun scriptLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptLinkedService = mapped
    }

    /**
     * @param argument Script linked service reference.
     */
    @JvmName("ceaotpvpmfminmqt")
    public suspend fun scriptLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scriptLinkedService = mapped
    }

    /**
     * @param value Script path. Type: string (or Expression with resultType string).
     */
    @JvmName("yxnxfolhqfocvlvc")
    public suspend fun scriptPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptPath = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rrvclbfmnrefjtaw")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("qoklcdpkcmvflpil")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("shifrdqgfpwhcoai")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Storage linked service references.
     */
    @JvmName("iefkqvdxrvijfedy")
    public suspend fun storageLinkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("uiwdtbysfslnakrd")
    public suspend fun storageLinkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("hvajyolmxijudemb")
    public suspend fun storageLinkedServices(vararg argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param argument Storage linked service references.
     */
    @JvmName("wivlurfygsqynnnd")
    public suspend fun storageLinkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageLinkedServices = mapped
    }

    /**
     * @param values Storage linked service references.
     */
    @JvmName("klqdfcpfqxucjhrr")
    public suspend fun storageLinkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageLinkedServices = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'HDInsightPig'.
     */
    @JvmName("vuiansyxkqvrcaho")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("jcnxxomukjwesxhd")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("iefgffbrxnmralft")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("teqklibyqxspulkh")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("oqbgllivodakjftb")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("pmydwushjrpagotj")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): HDInsightPigActivityArgs = HDInsightPigActivityArgs(
        arguments = arguments,
        defines = defines,
        dependsOn = dependsOn,
        description = description,
        getDebugInfo = getDebugInfo,
        linkedServiceName = linkedServiceName,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        scriptLinkedService = scriptLinkedService,
        scriptPath = scriptPath,
        state = state,
        storageLinkedServices = storageLinkedServices,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
